/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.warp;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.warp.AbstractWarpCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetWarpCommand
extends AbstractWarpCommand
implements PlayerCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (!(atPlayer instanceof ATFloodgatePlayer) || !MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                CustomMessages.sendMessage(sender, "Error.noWarpInput", new TagResolver[0]);
                return false;
            }
            ((ATFloodgatePlayer)atPlayer).sendSetWarpForm();
            return true;
        }
        Location warp = player.getLocation();
        if (!AdvancedTeleportAPI.isWarpSet(args[0])) {
            AdvancedTeleportAPI.setWarp(args[0], (CommandSender)player, warp).whenComplete((result, err) -> CustomMessages.failableContextualPath(sender, player.getUniqueId(), "Info.setWarp", "Error.setWarpFail", err, new TagResolver[]{Placeholder.unparsed((String)"warp", (String)result.getName())}));
        } else {
            CustomMessages.sendMessage(sender, "Error.warpAlreadySet", new TagResolver[]{Placeholder.unparsed((String)"warp", (String)args[0])});
        }
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.setwarp";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return null;
    }
}

