/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.warp;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.commands.warp.AbstractWarpCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class DeleteWarpCommand
extends AbstractWarpCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        if (args.length == 0) {
            Player player;
            ATPlayer atPlayer;
            if (sender instanceof Player && (atPlayer = ATPlayer.getPlayer(player = (Player)sender)) instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!AdvancedTeleportAPI.getWarps().isEmpty()) {
                        atFloodgatePlayer.sendDeleteWarpForm();
                    } else {
                        CustomMessages.sendMessage(sender, "Error.noWarps", new TagResolver[0]);
                    }
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noWarpInput", new TagResolver[0]);
            return false;
        }
        Warp warp = AdvancedTeleportAPI.getWarp(args[0]);
        if (warp == null) {
            CustomMessages.sendMessage(sender, "Error.noWarpInput", new TagResolver[0]);
            return false;
        }
        warp.delete(sender).whenCompleteAsync((ignored, exception) -> CustomMessages.failable(sender, "Info.deletedWarp", "Error.deleteWarpFail", exception, new TagResolver[]{Placeholder.unparsed((String)"warp", (String)args[0])}));
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.delwarp";
    }
}

