/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.ATCommand;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class Tpr
extends ATCommand
implements TimedATCommand {
    private static final List<UUID> searchingPlayers = new ArrayList<UUID>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Player player;
        if (!this.canProceed(sender)) {
            return true;
        }
        if (args.length > 1 && sender.hasPermission("at.admin.tpr.other")) {
            player = Bukkit.getPlayer((String)args[1]);
            if (player == null) {
                CustomMessages.sendMessage(sender, "Error.noSuchPlayer", new TagResolver[0]);
                return true;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            CustomMessages.sendMessage(sender, "Error.notAPlayer", new TagResolver[0]);
            return true;
        }
        World world = player.getWorld();
        if (args.length > 0 && sender.hasPermission("at.member.tpr.other")) {
            World otherWorld = Bukkit.getWorld((String)args[0]);
            if (otherWorld != null) {
                world = otherWorld;
            } else {
                CustomMessages.sendMessage(sender, "Error.noSuchWorld", new TagResolver[0]);
                return true;
            }
        }
        return Tpr.randomTeleport(player, sender, world);
    }

    public static boolean randomTeleport(Player player, World world) {
        return Tpr.randomTeleport(player, (CommandSender)player, world);
    }

    public static boolean randomTeleport(Player player, CommandSender sender, World world) {
        List<String> allowedWorlds;
        int cooldown = CooldownManager.secondsLeftOnCooldown("tpr", player);
        if (cooldown > 0) {
            CustomMessages.sendMessage(sender, "Error.onCooldown", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(cooldown))});
            return true;
        }
        if (MainConfig.get().WHITELIST_WORLD.get().booleanValue() && !sender.hasPermission("at.admin.rtp.bypass-world") && !(allowedWorlds = MainConfig.get().ALLOWED_WORLDS.get()).contains(world.getName())) {
            if (allowedWorlds.isEmpty() || !MainConfig.get().REDIRECT_TO_WORLD.get().booleanValue()) {
                CustomMessages.sendMessage(sender, "Error.cantTPToWorld", new TagResolver[0]);
                return true;
            }
            for (String worldName : allowedWorlds) {
                world = Bukkit.getWorld((String)worldName);
                String conditionResult = ConditionChecker.canTeleport(new Location(player.getWorld(), 0.0, 0.0, 0.0), new Location(world, 0.0, 0.0, 0.0), "tpr", player);
                if (world == null || conditionResult != null) continue;
                break;
            }
            if (world == null) {
                CustomMessages.sendMessage(sender, "Error.cantTPToWorld", new TagResolver[0]);
                return true;
            }
        }
        if (searchingPlayers.contains(player.getUniqueId())) {
            CustomMessages.sendMessage(sender, "Error.alreadySearching", new TagResolver[0]);
            return true;
        }
        String conditionResult = ConditionChecker.canTeleport(new Location(player.getWorld(), 0.0, 0.0, 0.0), new Location(world, 0.0, 0.0, 0.0), "tpr", player);
        if (conditionResult != null) {
            CustomMessages.sendMessage((CommandSender)player, conditionResult, new TagResolver[]{Placeholder.unparsed((String)"world", (String)world.getName())});
            return true;
        }
        if (!PaymentManager.getInstance().canPay("tpr", player, world)) {
            return true;
        }
        CustomMessages.sendMessage((CommandSender)player, "Info.searching", new TagResolver[0]);
        searchingPlayers.add(player.getUniqueId());
        AdvancedTeleportAPI.getRandomLocation(world, player).whenCompleteAsync((result, err) -> {
            if (err != null) {
                CustomMessages.sendMessage(sender, "Error.randomLocFailed", new TagResolver[0]);
                searchingPlayers.remove(player.getUniqueId());
                return;
            }
            Tpr.processLocation(player, result);
        }, CoreClass.sync);
        return true;
    }

    private static void processLocation(Player player, Location location) {
        searchingPlayers.remove(player.getUniqueId());
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        ATTeleportEvent event = new ATTeleportEvent(player, location, player.getLocation(), "", ATTeleportEvent.TeleportType.TPR);
        Bukkit.getPluginManager().callEvent((Event)event);
        atPlayer.teleport(event, "tpr", "Teleport.teleportingToRandomPlace");
    }

    @Override
    public boolean getRequiredFeature() {
        return MainConfig.get().USE_RANDOMTP.get();
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.tpr";
    }

    @Override
    @NotNull
    public String getSection() {
        return "tpr";
    }

    @Override
    public boolean canProceed(@NotNull CommandSender sender) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return TimedATCommand.super.canProceed(sender);
    }
}

