/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public final class TpoHere
extends TeleportATCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!atFloodgatePlayer.getVisiblePlayerNames().isEmpty()) {
                        atFloodgatePlayer.sendTpoHereForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noOthersToTP", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
            return false;
        }
        if (args[0].equalsIgnoreCase(player.getName())) {
            CustomMessages.sendMessage(sender, "Error.requestSentToSelf", new TagResolver[0]);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlayer", new TagResolver[0]);
            return true;
        }
        CustomMessages.sendMessage(sender, "Teleport.teleportingPlayerToSelf", new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())});
        CustomMessages.sendMessage((CommandSender)target, "Teleport.teleportingSelfToPlayer", new TagResolver[]{Placeholder.unparsed((String)"player", (String)sender.getName())});
        ATPlayer.teleportWithOptions(target, player.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.tpohere";
    }
}

