/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.api.TeleportRequestType;
import io.github.niestrat99.advancedteleport.api.events.players.TeleportRequestEvent;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class Tpa
extends TeleportATCommand
implements TimedATCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(final @NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        final Player player = (Player)sender;
        if (args.length == 0) {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!atFloodgatePlayer.getVisiblePlayerNames().isEmpty()) {
                        atFloodgatePlayer.sendTPAForm(false);
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noOthersToTP", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
            return false;
        }
        final Player target = Bukkit.getPlayer((String)args[0]);
        String result = ConditionChecker.canTeleport(player, target, "tpa");
        if (result != null) {
            CustomMessages.sendMessage((CommandSender)player, result, new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[0]), Placeholder.unparsed((String)"world", (String)(target == null ? "<No Such World>" : target.getWorld().getName()))});
            return true;
        }
        if (!PaymentManager.getInstance().canPay("tpa", player, target.getWorld())) return true;
        int requestLifetime = MainConfig.get().REQUEST_LIFETIME.get();
        TeleportRequestEvent event = new TeleportRequestEvent(target, player, TeleportRequestType.TPA);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        CustomMessages.sendMessage(sender, "Info.requestSent", new TagResolver[]{Placeholder.parsed((String)"player", (String)MiniMessage.miniMessage().escapeTags(target.getName())), Placeholder.unparsed((String)"lifetime", (String)String.valueOf(requestLifetime)), Placeholder.component((String)"lifetime-formatted", (ComponentLike)CustomMessages.toTime(requestLifetime))});
        CoreClass.playSound("tpa", "sent", player);
        ATPlayer targetPlayer = ATPlayer.getPlayer(target);
        if (targetPlayer instanceof ATFloodgatePlayer && MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
            ((ATFloodgatePlayer)targetPlayer).sendRequestFormTPA(player);
        } else {
            CustomMessages.sendMessage((CommandSender)target, "Info.tpaRequestReceived", new TagResolver[]{Placeholder.parsed((String)"player", (String)MiniMessage.miniMessage().escapeTags(sender.getName())), Placeholder.unparsed((String)"lifetime", (String)String.valueOf(requestLifetime)), Placeholder.component((String)"lifetime-formatted", (ComponentLike)CustomMessages.toTime(requestLifetime))});
        }
        CoreClass.playSound("tpa", "received", target);
        BukkitRunnable run = new BukkitRunnable(){

            public void run() {
                TeleportRequest request = TeleportRequest.getRequestByReqAndResponder(target, player);
                if (request == null) {
                    return;
                }
                if (MainConfig.get().NOTIFY_ON_EXPIRE.get().booleanValue()) {
                    CustomMessages.sendMessage(sender, "Error.requestExpired", new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())});
                }
                TeleportRequest.removeRequest(request);
            }
        };
        run.runTaskLater((Plugin)CoreClass.getInstance(), (long)requestLifetime * 20L);
        TeleportRequest request = new TeleportRequest(player, target, run, TeleportRequestType.TPA);
        TeleportRequest.addRequest(request);
        if (!MainConfig.get().APPLY_COOLDOWN_AFTER.get().equalsIgnoreCase("request")) return true;
        CooldownManager.addToCooldown("tpa", player, target.getWorld());
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.tpa";
    }

    @Override
    @NotNull
    public String getSection() {
        return "tpa";
    }
}

