/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TpUnblock
extends TeleportATCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (args.length == 0) {
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!atFloodgatePlayer.getVisiblePlayerNames().isEmpty()) {
                        atFloodgatePlayer.sendUnblockForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
            return false;
        }
        if (args[0].equalsIgnoreCase(player.getName())) {
            CustomMessages.sendMessage(sender, "Error.blockSelf", new TagResolver[0]);
            return true;
        }
        AdvancedTeleportAPI.getOfflinePlayer(args[0]).whenComplete((target, err1) -> {
            if (!atPlayer.hasBlocked((OfflinePlayer)target)) {
                CustomMessages.sendMessage(sender, "Error.neverBlocked", new TagResolver[0]);
                return;
            }
            atPlayer.unblockUser(target.getUniqueId()).whenCompleteAsync((ignored, err) -> CustomMessages.failable(sender, "Info.unblockPlayer", "Error.unblockFail", err, new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())}), CoreClass.async);
        });
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.unblock";
    }
}

