/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.utilities.PagedLists;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TpList
extends TeleportATCommand
implements PlayerCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (TeleportRequest.getRequests(player).isEmpty()) {
            CustomMessages.sendMessage((CommandSender)player, "Error.noRequests", new TagResolver[0]);
            return true;
        }
        if (args.length == 0) {
            PagedLists<TeleportRequest> requests = new PagedLists<TeleportRequest>(TeleportRequest.getRequests(player), 8);
            TpList.sendWithHeader(1, requests, player);
            return true;
        }
        if (args[0].matches("^[0-9]+$")) {
            int page = Integer.parseInt(args[0]);
            PagedLists<TeleportRequest> requests = new PagedLists<TeleportRequest>(TeleportRequest.getRequests(player), 8);
            try {
                TpList.sendWithHeader(page, requests, player);
            }
            catch (IllegalArgumentException ex) {
                CustomMessages.sendMessage((CommandSender)player, "Error.invalidPageNo", new TagResolver[0]);
            }
        } else {
            CustomMessages.sendMessage((CommandSender)player, "Error.invalidPageNo", new TagResolver[0]);
        }
        return true;
    }

    private static void sendWithHeader(int page, @NotNull PagedLists<TeleportRequest> requests, @NotNull Player player) {
        Component body = CustomMessages.getPagesComponent(page, requests, request -> CustomMessages.get("Info.multipleRequestsIndex", new TagResolver[]{Placeholder.unparsed((String)"command", (String)"/tpayes"), Placeholder.unparsed((String)"player", (String)request.requester().getName())}));
        CustomMessages.sendMessage((CommandSender)player, "Info.multipleRequestAccept", new TagResolver[0]);
        CustomMessages.sendMessage((CommandSender)player, body);
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.list";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return null;
    }
}

