/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TpBlockCommand
extends TeleportATCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (args.length == 0) {
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!atFloodgatePlayer.getVisiblePlayerNames().isEmpty()) {
                        atFloodgatePlayer.sendBlockForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
            return false;
        }
        if (args[0].equalsIgnoreCase(player.getName())) {
            CustomMessages.sendMessage(sender, "Error.blockSelf", new TagResolver[0]);
            return true;
        }
        AdvancedTeleportAPI.getOfflinePlayer(args[0]).whenComplete((target, err1) -> {
            if (atPlayer.hasBlocked((OfflinePlayer)target)) {
                CustomMessages.sendMessage(sender, "Error.alreadyBlocked", new TagResolver[0]);
                return;
            }
            if (args.length > 1) {
                StringBuilder reason = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    reason.append(args[i]).append(" ");
                }
                atPlayer.blockUser((OfflinePlayer)target, reason.toString().trim()).whenCompleteAsync((ignored, err) -> CustomMessages.failable(sender, "Info.block", "Error.blockFail", err, new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())}));
            } else {
                atPlayer.blockUser((OfflinePlayer)target).whenCompleteAsync((ignored, err) -> CustomMessages.failable(sender, "Info.blockPlayer", "Error.blockFail", err, new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())}));
            }
        });
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.block";
    }
}

