/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.spawn;

import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.SpawnATCommand;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnCommand
extends SpawnATCommand
implements TimedATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Spawn tempSpawn;
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        Spawn spawn = AdvancedTeleportAPI.getDestinationSpawn(player.getWorld(), player);
        if (args.length > 0 && (player.hasPermission("at.admin.spawn") || player.hasPermission("at.member.spawn." + args[0].toLowerCase())) && args[0].matches("^[0-9A-Za-z\\-_]+$") && (tempSpawn = NamedLocationManager.get().getSpawn(args[0])) != null) {
            spawn = tempSpawn;
        }
        SpawnCommand.spawn(player, spawn);
        return true;
    }

    public static void spawn(Player player, Spawn spawn) {
        ATTeleportEvent event = new ATTeleportEvent(player, spawn.getLocation(), player.getLocation(), "spawn", ATTeleportEvent.TeleportType.SPAWN);
        Bukkit.getPluginManager().callEvent((Event)event);
        ATPlayer.getPlayer(player).teleport(event, "spawn", "Teleport.teleportingToSpawn");
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.spawn";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("at.admin.spawn") && sender instanceof Player && args.length == 1) {
            ArrayList<String> spawns = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], (Iterable)AdvancedTeleportAPI.getSpawns().keySet(), spawns);
            return spawns;
        }
        return null;
    }

    @Override
    @NotNull
    public String getSection() {
        return "spawn";
    }
}

