/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.spawn;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.commands.SpawnATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetMainSpawn
extends SpawnATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        String id;
        if (!this.canProceed(sender)) {
            return true;
        }
        boolean world = true;
        if (args.length > 0) {
            id = args[0];
            world = false;
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            id = player.getWorld().getName();
        } else {
            CustomMessages.sendMessage(sender, "Error.cannotSetMainSpawnConsole", new TagResolver[0]);
            return true;
        }
        Spawn spawn = AdvancedTeleportAPI.getSpawn(id);
        if (spawn == null) {
            if (sender.hasPermission("at.admin.setspawn") && (world || sender.hasPermission("at.admin.setspawn.other"))) {
                Location loc = ((Player)sender).getLocation();
                AdvancedTeleportAPI.setSpawn(id, sender, loc).thenAcceptAsync(newSpawn -> this.setMainSpawn((Spawn)newSpawn, sender), CoreClass.sync);
            } else {
                CustomMessages.sendMessage(sender, "Error.cannotSetMainSpawn", new TagResolver[0]);
            }
            return true;
        }
        if (world && sender.hasPermission("at.admin.setspawn")) {
            Location loc = ((Player)sender).getLocation();
            AdvancedTeleportAPI.setSpawn(id, sender, loc).thenAcceptAsync(newSpawn -> this.setMainSpawn((Spawn)newSpawn, sender), CoreClass.sync);
            return true;
        }
        this.setMainSpawn(spawn, sender);
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.setmainspawn";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("at.admin.setmainspawn") && sender instanceof Player && args.length == 1) {
            ArrayList<String> spawns = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], (Iterable)AdvancedTeleportAPI.getSpawns().keySet(), spawns);
            return spawns;
        }
        return null;
    }

    private void setMainSpawn(Spawn spawn, CommandSender sender) {
        AdvancedTeleportAPI.setMainSpawn(spawn, sender).whenComplete((v, e) -> CustomMessages.failable(sender, "Info.setMainSpawn", "Error.setMainSpawnFail", e, new TagResolver[]{Placeholder.unparsed((String)"spawn", (String)spawn.getName())}));
    }
}

