/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.spawn;

import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.commands.SpawnATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoveSpawn
extends SpawnATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Spawn spawn;
        if (!this.canProceed(sender)) {
            return true;
        }
        String removingSpawn = "";
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                removingSpawn = player.getWorld().getName();
            } else {
                CustomMessages.sendMessage(sender, "Error.removeSpawnNoArgs", new TagResolver[0]);
                return false;
            }
        }
        if (args.length > 0) {
            removingSpawn = args[0];
        }
        if ((spawn = AdvancedTeleportAPI.getSpawn(removingSpawn)) == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchSpawn", new TagResolver[]{Placeholder.unparsed((String)"spawn", (String)removingSpawn)});
            return true;
        }
        spawn.delete(sender).whenComplete((ignored, err) -> CustomMessages.failable(sender, "Info.removedSpawn", "Error.removeSpawnFail", err, new TagResolver[]{Placeholder.unparsed((String)"spawn", (String)spawn.getName())}));
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.removespawn";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("at.admin.removespawn") && sender instanceof Player && args.length == 1) {
            ArrayList<String> spawns = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], (Iterable)AdvancedTeleportAPI.getSpawns().keySet(), spawns);
            return spawns;
        }
        return null;
    }
}

