/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.spawn;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.commands.SpawnATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MirrorSpawn
extends SpawnATCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Spawn fromSpawn;
        Spawn toSpawn;
        if (!this.canProceed(sender)) {
            return true;
        }
        if (args.length == 0) {
            CustomMessages.sendMessage(sender, "Error.mirrorSpawnNoArguments", new TagResolver[0]);
            return false;
        }
        if (args.length == 1) {
            toSpawn = this.getSpawn(args[0]);
            if (!(sender instanceof Player)) {
                CustomMessages.sendMessage(sender, "Error.mirrorSpawnLackOfArguments", new TagResolver[0]);
                return false;
            }
            Player player = (Player)sender;
            fromSpawn = AdvancedTeleportAPI.getSpawn(player.getWorld());
        } else {
            fromSpawn = this.getSpawn(args[0]);
            toSpawn = this.getSpawn(args[1]);
        }
        if (fromSpawn != toSpawn) {
            fromSpawn.setMirroringSpawn(toSpawn, sender).whenCompleteAsync((v, e) -> this.handleCommandFeedback((Throwable)e, sender, "Info.mirroredSpawn", "Error.mirrorSpawnFail", new TagResolver[]{Placeholder.unparsed((String)"spawn", (String)(v == null ? "[None]" : v.getName())), Placeholder.unparsed((String)"from", (String)fromSpawn.getName())}), CoreClass.sync);
            return true;
        }
        CustomMessages.sendMessage(sender, "Info.mirrorSpawnSame", new TagResolver[]{Placeholder.unparsed((String)"spawn", (String)args[0]), Placeholder.unparsed((String)"from", (String)(args.length == 1 ? ((Player)sender).getWorld().getName() : args[1]))});
        return true;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length == 1 || args.length == 2) {
            ArrayList<String> spawns = new ArrayList<String>();
            spawns.addAll((Collection<String>)AdvancedTeleportAPI.getSpawns().keySet());
            spawns.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(world -> !spawns.contains(world)).toList());
            StringUtil.copyPartialMatches((String)args[args.length - 1], spawns, results);
        }
        return results;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.mirrorspawn";
    }

    @NotNull
    private Spawn getSpawn(String name) {
        Spawn spawn = AdvancedTeleportAPI.getSpawn(name);
        if (spawn == null) {
            World world = Bukkit.getWorld((String)name);
            if (world == null) {
                throw new IllegalArgumentException("World " + name + " does not exist!");
            }
            spawn = AdvancedTeleportAPI.getSpawn(world);
        }
        return spawn;
    }
}

