/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class SetHomeCommand
extends AbstractHomeCommand
implements PlayerCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (args.length == 0) {
            int limit = atPlayer.getHomesLimit();
            if (atPlayer.getHomes().isEmpty() && (limit > 0 || limit == -1)) {
                this.setHome(player, "home");
                return true;
            }
            if (!(atPlayer instanceof ATFloodgatePlayer) || !MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                CustomMessages.sendMessage(sender, "Error.noHomeInput", new TagResolver[0]);
                return false;
            }
            ((ATFloodgatePlayer)atPlayer).sendSetHomeForm();
            return true;
        }
        if (args.length > 1 && sender.hasPermission(this.getAdminPermission())) {
            AdvancedTeleportAPI.getOfflinePlayer(args[0]).whenCompleteAsync((target, err) -> this.setHome(player, (OfflinePlayer)target, args[1], args[0]));
            return true;
        }
        if (atPlayer.canSetMoreHomes() || MainConfig.get().OVERWRITE_SETHOME.get().booleanValue() && atPlayer.hasHome(args[0])) {
            this.setHome(player, args[0]);
        } else {
            CustomMessages.sendMessage(sender, "Error.reachedHomeLimit", new TagResolver[0]);
        }
        return true;
    }

    private void setHome(Player sender, String name) {
        this.setHome(sender, (OfflinePlayer)sender, name, sender.getName());
    }

    private void setHome(Player sender, OfflinePlayer target, String homeName, String playerName) {
        ATPlayer atPlayer = ATPlayer.getPlayer(target);
        if (!MainConfig.get().OVERWRITE_SETHOME.get().booleanValue() && atPlayer.hasHome(homeName)) {
            CustomMessages.sendMessage((CommandSender)sender, "Error.homeAlreadySet", new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName)});
            return;
        }
        atPlayer.addHome(homeName, sender.getLocation(), sender).whenComplete((ignored, err) -> CustomMessages.failableContextualPath((CommandSender)sender, target, "Info.setHome", "Error.setHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName), Placeholder.unparsed((String)"player", (String)playerName)}));
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.sethome";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.sethome";
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

