/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import com.google.common.collect.ImmutableCollection;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.utilities.PermissionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class HomesCommand
extends AbstractHomeCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        if (args.length > 0 && sender.hasPermission("at.admin.homes")) {
            CoreClass.debug("Admin player has requested the homes of " + args[0] + " - fetching...");
            ATPlayer.getPlayerFuture(args[0]).whenCompleteAsync((player, err) -> {
                CoreClass.debug("Player fetched.");
                if (err != null) {
                    CoreClass.getInstance().getLogger().throwing(HomesCommand.class.getName(), "onCommand", (Throwable)err);
                    return;
                }
                CoreClass.debug("No errors after fetching.");
                player.getHomesAsync().whenCompleteAsync((homes, err2) -> {
                    CoreClass.debug("Homes of " + args[0] + " fetched.");
                    if (err2 != null) {
                        CoreClass.getInstance().getLogger().throwing(HomesCommand.class.getName(), "onCommand", (Throwable)err2);
                        return;
                    }
                    CoreClass.debug("No errors after fetching homes.");
                    this.getHomes(sender, player.getOfflinePlayer(), (ImmutableCollection<Home>)homes.values());
                }, CoreClass.sync);
            }, CoreClass.sync);
            return true;
        }
        if (!(sender instanceof Player)) {
            CustomMessages.sendMessage(sender, "Error.notAPlayer", new TagResolver[0]);
            return true;
        }
        Player player2 = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player2);
        atPlayer.getHomesAsync().whenCompleteAsync((homes, err) -> {
            if (err != null) {
                err.printStackTrace();
                return;
            }
            this.getHomes(sender, (OfflinePlayer)player2, (ImmutableCollection<Home>)homes.values());
        }, CoreClass.sync);
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.homes";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.homes";
    }

    private void getHomes(CommandSender sender, OfflinePlayer target, ImmutableCollection<Home> homes) {
        ATPlayer atPlayer = ATPlayer.getPlayer(target);
        if (sender == target && atPlayer instanceof ATFloodgatePlayer) {
            ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
            if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                CoreClass.debug("Sender is being sent a homes form.");
                if (!atFloodgatePlayer.getHomes().isEmpty()) {
                    atFloodgatePlayer.sendHomeForm();
                } else {
                    CustomMessages.sendMessage(sender, CustomMessages.contextualPath(sender, target, "Error.noHomes"), new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())});
                }
                return;
            }
        }
        TextComponent body = (TextComponent)Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), homes.stream().map(home -> new Object[]{home, atPlayer.canAccessHome((Home)home) || PermissionUtil.hasPermissionOrStar((Permissible)sender, "at.admin.homes")}).map(pair -> {
            Home home = (Home)pair[0];
            boolean canAccess = (Boolean)pair[1];
            TextComponent baseComponent = (TextComponent)Component.text((String)home.getName()).hoverEvent(CustomMessages.locationBasedTooltip(sender, home, "homes"));
            CoreClass.debug("Processing home: " + home.getName() + ", " + canAccess);
            if (!canAccess) {
                if (!MainConfig.get().HIDE_HOMES_IF_DENIED.get().booleanValue()) {
                    return Component.empty();
                }
                return (TextComponent)((TextComponent)baseComponent.color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC);
            }
            return (TextComponent)baseComponent.clickEvent(ClickEvent.runCommand((String)("/advancedteleport:home " + (String)(sender == target ? "" : target.getName() + " ") + home.getName())));
        }).toList());
        CoreClass.debug("Message text built.");
        if (!body.content().isEmpty() || !body.children().isEmpty()) {
            String text = CustomMessages.config.getString("Info.homes") + "<homes>";
            Component component = CustomMessages.translate(text, new TagResolver[]{Placeholder.component((String)"homes", (ComponentLike)body)});
            CustomMessages.sendMessage(sender, component);
        } else {
            CustomMessages.sendMessage(sender, CustomMessages.contextualPath(sender, target, "Error.noHomes"), new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName())});
        }
    }
}

