/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import com.google.common.collect.ImmutableMap;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class HomeCommand
extends AbstractHomeCommand
implements TimedATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        ImmutableMap<String, Home> homes = atPlayer.getHomes();
        if (args.length > 1 && sender.hasPermission(this.getAdminPermission())) {
            ATPlayer.getPlayerFuture(args[0]).whenCompleteAsync((target, err) -> {
                if (err != null) {
                    err.printStackTrace();
                    return;
                }
                target.getHomesAsync().whenCompleteAsync((homesOther, err2) -> {
                    if (err2 != null) {
                        err2.printStackTrace();
                        return;
                    }
                    Home home = (Home)homesOther.get((Object)args[1]);
                    if (home != null) {
                        ATPlayer.teleportWithOptions(player, home.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
                        CustomMessages.sendMessage(sender, "Teleport.teleportingToHomeOther", new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[0]), Placeholder.unparsed((String)"home", (String)args[1])});
                        return;
                    }
                    if (args[1].equalsIgnoreCase("bed") && MainConfig.get().ADD_BED_TO_HOMES.get().booleanValue() && (home = target.getBedSpawn()) != null) {
                        ATPlayer.teleportWithOptions(player, home.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
                        CustomMessages.sendMessage(sender, "Teleport.teleportingToHomeOther", new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[0]), Placeholder.unparsed((String)"home", (String)args[1])});
                        return;
                    }
                    if (args[1].equalsIgnoreCase("list")) {
                        Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)sender, (String)("advancedteleport:homes " + args[0])));
                        return;
                    }
                    CustomMessages.sendMessage(sender, "Error.noSuchHome", new TagResolver[0]);
                }, CoreClass.sync);
            }, CoreClass.sync);
            return true;
        }
        if (args.length == 0) {
            Home home;
            if (!(!MainConfig.get().SHOW_HOMES_WITH_NO_INPUT.get().booleanValue() || atPlayer.hasMainHome() && MainConfig.get().PRIORITISE_MAIN_HOME.get().booleanValue())) {
                Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)sender, (String)"advancedteleport:homes"));
            }
            if ((home = atPlayer.getMainHome()) != null) {
                HomeCommand.teleport(player, home);
                return true;
            }
            if (homes.size() == 1) {
                home = (Home)homes.values().iterator().next();
                if (atPlayer.canAccessHome(home)) {
                    HomeCommand.teleport(player, home);
                } else {
                    CustomMessages.sendMessage(sender, "Error.noAccessHome", new TagResolver[]{Placeholder.unparsed((String)"home", (String)home.getName())});
                }
                return true;
            }
            if (MainConfig.get().ADD_BED_TO_HOMES.get().booleanValue() && (home = atPlayer.getBedSpawn()) != null) {
                HomeCommand.teleport(player, home);
                return true;
            }
            if (homes.isEmpty()) {
                CustomMessages.sendMessage(sender, "Error.noHomes", new TagResolver[0]);
            } else {
                CustomMessages.sendMessage(sender, "Error.noHomeInput", new TagResolver[0]);
            }
            return true;
        }
        Home home = atPlayer.getHome(args[0]);
        if (home != null && atPlayer.canAccessHome(home)) {
            HomeCommand.teleport(player, home);
            return true;
        }
        if (args[0].equalsIgnoreCase("bed") && MainConfig.get().ADD_BED_TO_HOMES.get().booleanValue()) {
            home = atPlayer.getBedSpawn();
            if (home == null) {
                CustomMessages.sendMessage((CommandSender)player, "Error.noBedHome", new TagResolver[0]);
                return true;
            }
            HomeCommand.teleport(player, home);
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)sender, (String)("advancedteleport:homes " + args[0])));
            return true;
        }
        if (MainConfig.get().SHOW_HOMES_WITH_NO_INPUT.get().booleanValue()) {
            player.performCommand("advancedteleport:homes");
            return true;
        }
        CustomMessages.sendMessage(sender, home == null ? "Error.noSuchHome" : "Error.noAccessHome", new TagResolver[]{Placeholder.unparsed((String)"home", (String)args[0])});
        return true;
    }

    public static void teleport(@NotNull Player player, @NotNull Home home) {
        ATTeleportEvent event = new ATTeleportEvent(player, home.getLocation(), player.getLocation(), home.getName(), ATTeleportEvent.TeleportType.HOME);
        Bukkit.getPluginManager().callEvent((Event)event);
        ATPlayer.getPlayer(player).teleport(event, "home", "Teleport.teleportingToHome");
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.home";
    }

    @Override
    @NotNull
    public String getSection() {
        return "home";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.home";
    }
}

