/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.commands.ATCommand;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHomeCommand
extends ATCommand {
    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (player.hasPermission(this.getAdminPermission()) && !args[0].isEmpty() && args.length == 2) {
            ATPlayer atTarget = ATPlayer.getPlayer(args[0]);
            if (atTarget == null) {
                return Collections.emptyList();
            }
            return (List)StringUtil.copyPartialMatches((String)args[1], (Iterable)atTarget.getHomes().keySet(), new ArrayList());
        }
        if (args.length == 1) {
            ATPlayer atSender = ATPlayer.getPlayer(player);
            ArrayList<String> accessibleHomes = new ArrayList<String>();
            for (Home home : atSender.getHomes().values()) {
                if (!cmd.getName().equals("delhome") && !atSender.canAccessHome(home)) continue;
                accessibleHomes.add(home.getName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], accessibleHomes, new ArrayList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean getRequiredFeature() {
        return MainConfig.get().USE_HOMES.get();
    }

    @NotNull
    public abstract String getAdminPermission();
}

