/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core.map;

import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.hooks.MapPlugin;
import io.github.niestrat99.advancedteleport.managers.MapAssetManager;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AbstractMapCommand
extends SubATCommand {
    @NotNull
    private final String key;
    @NotNull
    private final Collection<String> completions;
    @NotNull
    private final String successKey;

    public AbstractMapCommand(@NotNull String key, @NotNull String successKey, @NotNull Collection<String> completions) {
        this.key = key;
        this.successKey = successKey;
        this.completions = completions;
    }

    public AbstractMapCommand(@NotNull String key, @NotNull String successKey, String ... completions) {
        this(key, successKey, new ArrayList<String>(Arrays.asList(completions)));
    }

    @Contract
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        CompletableFuture<Boolean> completableFuture;
        if (args.length < 3) {
            CustomMessages.sendMessage(sender, "Error.notEnoughArgs", new TagResolver[0]);
            return false;
        }
        String input = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        switch (args[0].toLowerCase()) {
            case "warp": {
                completableFuture = MetadataSQLManager.get().addWarpMetadata(args[1], this.key, input);
                break;
            }
            case "spawn": {
                completableFuture = MetadataSQLManager.get().addSpawnMetadata(args[1], this.key, input);
                break;
            }
            case "home": {
                if (args.length < 4) {
                    CustomMessages.sendMessage(sender, "Error.notEnoughArgs", new TagResolver[0]);
                    return false;
                }
                String finalInput = input = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
                AdvancedTeleportAPI.getOfflinePlayer(args[1]).whenComplete((player, err) -> {
                    if (err != null) {
                        CustomMessages.sendMessage(sender, "Error.failedMapIconUpdate", new TagResolver[0]);
                        err.printStackTrace();
                        return;
                    }
                    MetadataSQLManager.get().addHomeMetadata(args[2], player.getUniqueId(), this.key, finalInput).whenComplete((result, err2) -> CustomMessages.failable(sender, this.successKey, "Error.failedMapIconUpdate", err2, new TagResolver[]{Placeholder.unparsed((String)"type", (String)args[0]), Placeholder.unparsed((String)"name", (String)args[2])}));
                });
                return true;
            }
            default: {
                CustomMessages.sendMessage(sender, "Error.invalidArgs", new TagResolver[0]);
                return false;
            }
        }
        completableFuture.whenComplete((result, err) -> {
            CustomMessages.failable(sender, this.successKey, "Error.failedMapIconUpdate", err, new TagResolver[]{Placeholder.unparsed((String)"type", (String)args[0]), Placeholder.unparsed((String)"name", (String)args[1])});
            PluginHookManager.get().getPluginHooks(MapPlugin.class, true).forEach(mapPlugin -> mapPlugin.updateIcon(args[1], MapAssetManager.IconType.valueOf(args[0].toUpperCase()), null));
        });
        return true;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("warp", "spawn", "home"), new ArrayList());
        }
        if (args.length == 2) {
            return switch (args[0].toLowerCase()) {
                case "warp" -> (ArrayList)StringUtil.copyPartialMatches((String)args[1], (Iterable)AdvancedTeleportAPI.getWarps().keySet(), new ArrayList());
                case "spawn" -> (ArrayList)StringUtil.copyPartialMatches((String)args[1], (Iterable)AdvancedTeleportAPI.getSpawns().keySet(), new ArrayList());
                case "home" -> (ArrayList)StringUtil.copyPartialMatches((String)args[1], Bukkit.getOnlinePlayers().stream().filter(player -> !(sender instanceof Player) || ((Player)sender).canSee(player)).map(Player::getName).toList(), new ArrayList());
                default -> new ArrayList();
            };
        }
        if (args.length == 3) {
            return switch (args[0].toLowerCase()) {
                case "warp", "spawn" -> (ArrayList)StringUtil.copyPartialMatches((String)args[2], this.completions, new ArrayList());
                case "home" -> Optional.ofNullable(ATPlayer.getPlayer(args[1])).map(player -> player.getHomes().keySet()).map(homes -> (ArrayList)StringUtil.copyPartialMatches((String)args[2], (Iterable)homes, new ArrayList())).map(List.class::cast).orElse(List.of());
                default -> new ArrayList();
            };
        }
        if (args.length == 4 && args[3].equalsIgnoreCase("home")) {
            return (List)StringUtil.copyPartialMatches((String)args[3], this.completions, new ArrayList());
        }
        return List.of();
    }
}

