/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class PurgeCommand
extends SubATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length < 3) {
            CustomMessages.sendMessage(sender, "Error.tooFewArguments", new TagResolver[0]);
            return false;
        }
        if (!args[0].equalsIgnoreCase("warps") && !args[0].equalsIgnoreCase("homes")) {
            CustomMessages.sendMessage(sender, "Error.invalidArgs", new TagResolver[0]);
            return false;
        }
        if (!args[1].equalsIgnoreCase("world") && !args[1].equalsIgnoreCase("player")) {
            CustomMessages.sendMessage(sender, "Error.invalidArgs", new TagResolver[0]);
            return false;
        }
        if (args[1].equalsIgnoreCase("world")) {
            switch (args[0].toLowerCase()) {
                case "homes": {
                    CompletableFuture.runAsync(() -> HomeSQLManager.get().purgeHomes(args[2])).whenComplete((v, err) -> CustomMessages.failable(sender, "Info.purgeHomesWorld", "Error.purgeHomesFail", err, new TagResolver[]{Placeholder.unparsed((String)"world", (String)args[2])}));
                    break;
                }
                case "warps": {
                    CompletableFuture.runAsync(() -> WarpSQLManager.get().purgeWarps(args[2])).whenComplete((v, err) -> CustomMessages.failable(sender, "Info.purgeWarpsWorld", "Error.purgeWarpsFail", err, new TagResolver[]{Placeholder.unparsed((String)"world", (String)args[2])}));
                }
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("player")) {
            AdvancedTeleportAPI.getOfflinePlayer(args[2]).thenAcceptAsync(player -> {
                switch (args[0].toLowerCase()) {
                    case "homes": {
                        CompletableFuture.runAsync(() -> HomeSQLManager.get().purgeHomes(player.getUniqueId())).whenComplete((v, err) -> CustomMessages.failable(sender, "Info.purgeHomesCreator", "Error.purgeHomesFail", err, new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[2])}));
                        break;
                    }
                    case "warps": {
                        CompletableFuture.runAsync(() -> WarpSQLManager.get().purgeWarps(player.getUniqueId())).whenComplete((v, err) -> CustomMessages.failable(sender, "Info.purgeWarpsCreator", "Error.purgeWarpsFail", err, new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[2])}));
                    }
                }
            }, CoreClass.sync);
        }
        return true;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return switch (args.length) {
            case 1 -> (ArrayList)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("homes", "warps"), new ArrayList());
            case 2 -> (ArrayList)StringUtil.copyPartialMatches((String)args[1], Arrays.asList("player", "world"), new ArrayList());
            case 3 -> {
                if (args[1].equalsIgnoreCase("player")) {
                    ArrayList players = new ArrayList();
                    Bukkit.getOnlinePlayers().forEach(player -> players.add(player.getName()));
                    yield (ArrayList)StringUtil.copyPartialMatches((String)args[2], players, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("world")) {
                    ArrayList worlds = new ArrayList();
                    Bukkit.getWorlds().forEach(world -> worlds.add(world.getName()));
                    yield (ArrayList)StringUtil.copyPartialMatches((String)args[2], worlds, new ArrayList());
                }
                yield Collections.emptyList();
            }
            default -> Collections.emptyList();
        };
    }
}

