/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.commands.core.map.SetClickTooltipCommand;
import io.github.niestrat99.advancedteleport.commands.core.map.SetHoverTooltipCommand;
import io.github.niestrat99.advancedteleport.commands.core.map.SetIconCommand;
import io.github.niestrat99.advancedteleport.commands.core.map.SetSizeCommand;
import io.github.niestrat99.advancedteleport.commands.core.map.SetVisibleCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapCommand
extends SubATCommand {
    private static final HashMap<String, SubATCommand> subMapCommands = new HashMap();

    public MapCommand() {
        subMapCommands.put("seticon", new SetIconCommand());
        subMapCommands.put("setclicktooltip", new SetClickTooltipCommand());
        subMapCommands.put("sethovertooltip", new SetHoverTooltipCommand());
        subMapCommands.put("setsize", new SetSizeCommand());
        subMapCommands.put("setvisible", new SetVisibleCommand());
    }

    public static HashMap<String, SubATCommand> getSubMapCommands() {
        return subMapCommands;
    }

    @Contract(value="_, _, _, _ -> false", pure=true)
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 0) {
            Bukkit.dispatchCommand((CommandSender)sender, (String)"at help map");
            return true;
        }
        SubATCommand subATCommand = subMapCommands.get(args[0].toLowerCase());
        if (subATCommand == null) {
            Bukkit.dispatchCommand((CommandSender)sender, (String)"at help map");
            return true;
        }
        if (!sender.hasPermission("at.member.core.map." + args[0].toLowerCase())) {
            Bukkit.dispatchCommand((CommandSender)sender, (String)"at help map");
            return true;
        }
        boolean result = subATCommand.onCommand(sender, command, s, Arrays.copyOfRange(args, 1, args.length));
        if (!result) {
            CustomMessages.sendMessage(sender, "Error.commandUse", new TagResolver[]{Placeholder.unparsed((String)"usage", (String)CustomMessages.asString("Usages.Subcommands.map." + args[0].toLowerCase()))});
        }
        return true;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], subMapCommands.keySet().stream().filter(key -> sender.hasPermission("at.member.core.map." + key)).toList(), results);
            return results;
        }
        SubATCommand subATCommand = subMapCommands.get(args[0].toLowerCase());
        if (subATCommand == null) {
            return results;
        }
        return subATCommand.onTabComplete(sender, command, s, Arrays.copyOfRange(args, 1, args.length));
    }
}

