/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.commands.core.MapCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.CommandManager;
import io.github.niestrat99.advancedteleport.utilities.PagedLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class HelpCommand
extends SubATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<String> subcommands = new ArrayList<String>();
        ArrayList<Object> possibleCommands = new ArrayList<Object>();
        int page = 1;
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "warps": {
                    commands.add("warp");
                    commands.add("warps");
                    commands.add("movewarp");
                    commands.add("setwarp");
                    commands.add("delwarp");
                    break;
                }
                case "teleporting": {
                    commands.add("back");
                    commands.add("toggletp");
                    commands.add("tpa");
                    commands.add("tpahere");
                    commands.add("tpall");
                    commands.add("tpalist");
                    commands.add("tpblock");
                    commands.add("tpcancel");
                    commands.add("tploc");
                    commands.add("tpno");
                    commands.add("tpo");
                    commands.add("tpoff");
                    commands.add("tpoffline");
                    commands.add("tpofflinehere");
                    commands.add("tpohere");
                    commands.add("tpon");
                    commands.add("tpr");
                    commands.add("tpunblock");
                    commands.add("tpyes");
                    break;
                }
                case "core": {
                    subcommands.add("import");
                    subcommands.add("help");
                    subcommands.add("export");
                    subcommands.add("info");
                    subcommands.add("reload");
                    subcommands.add("purge");
                    break;
                }
                case "homes": {
                    commands.add("delhome");
                    commands.add("home");
                    commands.add("homes");
                    commands.add("movehome");
                    commands.add("sethome");
                    commands.add("setmainhome");
                    break;
                }
                case "spawns": {
                    commands.add("mirrorspawn");
                    commands.add("removespawn");
                    commands.add("setmainspawn");
                    commands.add("setspawn");
                    commands.add("spawn");
                    break;
                }
                case "map": {
                    subcommands.add("map.setclicktooltip");
                    subcommands.add("map.sethovertooltip");
                    subcommands.add("map.seticon");
                    subcommands.add("map.setsize");
                    subcommands.add("map.setvisible");
                    break;
                }
                default: {
                    if (args[0].matches("^\\d+$")) {
                        page = Integer.parseInt(args[0]);
                    }
                    commands.addAll(CommandManager.registeredCommands.keySet());
                    subcommands.addAll(CommandManager.subcommands.keySet());
                    MapCommand.getSubMapCommands().keySet().forEach(mapCommand -> subcommands.add("map." + mapCommand));
                }
            }
            if (args.length > 1 && args[1].matches("^\\d+$")) {
                page = Integer.parseInt(args[1]);
            }
        } else {
            commands.addAll(CommandManager.registeredCommands.keySet());
            subcommands.addAll(CommandManager.subcommands.keySet());
            MapCommand.getSubMapCommands().keySet().forEach(mapCommand -> subcommands.add("map." + mapCommand));
        }
        for (String command : commands) {
            PluginCommand pluginCommand = CommandManager.registeredCommands.get(command);
            if (pluginCommand == null || pluginCommand.getPermission() != null && !sender.hasPermission(pluginCommand.getPermission())) continue;
            possibleCommands.add(command);
        }
        for (String subcommand : subcommands) {
            if (!sender.hasPermission("at.member.core." + subcommand)) continue;
            possibleCommands.add("Subcommands." + subcommand);
        }
        PagedLists commandList = new PagedLists(possibleCommands, 7);
        if (page > commandList.getTotalPages()) {
            CustomMessages.sendMessage(sender, "Error.invalidPageNo", new TagResolver[0]);
            return true;
        }
        Component helpHeader = MiniMessage.miniMessage().deserialize(CustomMessages.config.getString("Menu.Help.header"), TagResolver.builder().tag("current_page", (Tag)Tag.preProcessParsed((String)String.valueOf(page))).tag("total_pages", (Tag)Tag.preProcessParsed((String)String.valueOf(commandList.getTotalPages()))).build());
        CustomMessages.sendMessage(sender, helpHeader);
        for (String command : commandList.getContentsInPage(page)) {
            Component adminComponent;
            Component commandUsage = CustomMessages.getComponent("Usages." + command, new TagResolver[0]);
            if ((sender.hasPermission("at.admin." + command) || sender.hasPermission("at.admin." + command + ".other")) && (adminComponent = CustomMessages.getComponent("Usages-Admin." + command, new TagResolver[0])) != Component.empty()) {
                commandUsage = adminComponent;
            }
            Component description = CustomMessages.getComponent("Descriptions." + command, new TagResolver[0]);
            Component finalMessage = MiniMessage.miniMessage().deserialize(CustomMessages.config.getString("Menu.Help.option"), TagResolver.builder().tag("usage", Tag.selfClosingInserting((Component)commandUsage)).tag("description", Tag.selfClosingInserting((Component)description)).build());
            CustomMessages.sendMessage(sender, finalMessage);
        }
        return true;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length != 1) {
            return List.of();
        }
        return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("core", "homes", "map", "spawns", "teleporting", "warps"), new ArrayList());
    }
}

