/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.commands.core.ImportCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.hooks.ImportExportPlugin;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class ExportCommand
extends SubATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 0) {
            CustomMessages.sendMessage(sender, "Error.noPluginSpecified", new TagResolver[0]);
            return false;
        }
        ImportExportPlugin<?, ?> pluginHook = ImportCommand.getImportExportPlugin(sender, args);
        if (pluginHook == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlugin", new TagResolver[0]);
            return true;
        }
        if (!pluginHook.canImport()) {
            CustomMessages.sendMessage(sender, "Error.cantExport", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
            return true;
        }
        CustomMessages.sendMessage(sender, "Info.exportStarted", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            String arg = args.length == 1 ? "all" : args[1];
            switch (arg.toLowerCase()) {
                case "homes": {
                    pluginHook.exportHomes();
                    break;
                }
                case "warps": {
                    pluginHook.exportWarps();
                    break;
                }
                case "lastlocs": {
                    pluginHook.exportLastLocations();
                    break;
                }
                case "spawns": {
                    pluginHook.exportSpawn();
                    break;
                }
                case "players": {
                    pluginHook.exportPlayerInformation();
                    break;
                }
                case "all": {
                    pluginHook.exportAll();
                    break;
                }
                default: {
                    CustomMessages.sendMessage(sender, "Error.invalidOption", new TagResolver[0]);
                    return;
                }
            }
            CustomMessages.sendMessage(sender, "Info.exportFinished", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
        });
        return true;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> possibilities = new ArrayList<String>();
        if (args.length == 1) {
            possibilities.addAll(PluginHookManager.get().getPluginHooks(ImportExportPlugin.class, true).collect(ArrayList::new, (list, plugin) -> list.add(plugin.pluginName()), ArrayList::addAll));
        }
        if (args.length == 2) {
            possibilities.addAll(Arrays.asList("all", "homes", "lastlocs", "warps", "spawns", "players"));
        }
        return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], possibilities, new ArrayList());
    }
}

