/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands;

import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.managers.MovementManager;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface TimedATCommand
extends PlayerCommand {
    @Override
    default public boolean canProceed(@NotNull CommandSender sender) {
        if (!PlayerCommand.super.canProceed(sender)) {
            return false;
        }
        Player player = (Player)sender;
        int cooldown = CooldownManager.secondsLeftOnCooldown(this.getSection(), player);
        if (cooldown > 0) {
            CustomMessages.sendMessage(sender, "Error.onCooldown", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(cooldown)), Placeholder.component((String)"time-formatted", (ComponentLike)CustomMessages.toTime(cooldown))});
            return false;
        }
        if (MovementManager.getMovement().containsKey(player.getUniqueId())) {
            CustomMessages.sendMessage((CommandSender)player, "Error.onCountdown", new TagResolver[0]);
            return false;
        }
        return true;
    }

    @NotNull
    public String getSection();
}

