/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.signs;

import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.commands.teleport.Tpr;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RandomTPSign
extends ATSign {
    public RandomTPSign() {
        super("RandomTP", MainConfig.get().USE_RANDOMTP.get());
    }

    @Override
    public void onInteract(@NotNull Sign sign, @NotNull Player player) {
        if (!sign.getLine(1).isEmpty()) {
            World otherWorld = Bukkit.getWorld((String)sign.getLine(1));
            if (otherWorld != null) {
                Tpr.randomTeleport(player, otherWorld);
            } else {
                CustomMessages.sendMessage((CommandSender)player, "Error.noSuchWorld", new TagResolver[0]);
            }
        } else {
            Tpr.randomTeleport(player, player.getWorld());
        }
    }

    @Override
    public boolean canCreate(@NotNull List<Component> lines, @NotNull Player player) {
        World otherWorld;
        Component component = lines.get(1);
        if (!(component instanceof TextComponent)) {
            return false;
        }
        TextComponent line = (TextComponent)component;
        if (!line.content().isEmpty() && (otherWorld = Bukkit.getWorld((String)line.content())) == null) {
            CustomMessages.sendMessage((CommandSender)player, "Error.noSuchWorld", new TagResolver[0]);
            return false;
        }
        return true;
    }
}

