/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events.warps;

import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.events.TrackableATEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WarpMoveEvent
extends TrackableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private final Warp warp;
    @NotNull
    private Location location;

    @Contract(pure=true)
    public WarpMoveEvent(@NotNull Warp warp, @NotNull Location location, @Nullable CommandSender sender) {
        super(sender);
        this.warp = warp;
        this.location = location;
    }

    @Contract(pure=true)
    @NotNull
    public Warp getWarp() {
        return this.warp;
    }

    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    public void setLocation(@NotNull Location location) throws IllegalStateException {
        if (!location.isWorldLoaded()) {
            throw new IllegalStateException("The new location's world is not loaded.");
        }
        this.location = location;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

