/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events.players;

import io.github.niestrat99.advancedteleport.api.events.CancellableATEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PreviousLocationChangeEvent
extends CancellableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @Nullable
    private final Location oldLocation;
    @Nullable
    private Location newLocation;
    @NotNull
    private OfflinePlayer player;

    @Contract(pure=true)
    public PreviousLocationChangeEvent(@NotNull OfflinePlayer player, @NotNull Location newLocation, @Nullable Location oldLocation) throws IllegalArgumentException {
        if (!newLocation.isWorldLoaded()) {
            throw new IllegalStateException("The new location's world is not loaded.");
        }
        this.player = player;
        this.newLocation = newLocation;
        this.oldLocation = oldLocation;
    }

    @Contract(pure=true)
    @NotNull
    public OfflinePlayer getPlayer() {
        return this.player;
    }

    @Contract(pure=true)
    public void setPlayer(@NotNull OfflinePlayer player) {
        this.player = player;
    }

    @Contract(pure=true)
    @Nullable
    public Location getNewLocation() {
        return this.newLocation;
    }

    @Contract(pure=true)
    public void setNewLocation(@Nullable Location newLocation) {
        this.newLocation = newLocation;
    }

    @Contract(pure=true)
    @Nullable
    public Location getOldLocation() {
        return this.oldLocation;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

