/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events.homes;

import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.events.TrackableATEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HomeMoveEvent
extends TrackableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private final Home home;
    @NotNull
    private Location location;

    @Contract(pure=true)
    public HomeMoveEvent(@NotNull Home home, @NotNull Location location, @Nullable CommandSender sender) {
        super(sender);
        this.home = home;
        this.location = location;
    }

    @Contract(pure=true)
    @NotNull
    public Home getHome() {
        return this.home;
    }

    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    public void setLocation(@NotNull Location location) {
        if (!location.isWorldLoaded()) {
            throw new IllegalStateException("The new location's world is not loaded.");
        }
        this.location = location;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

