/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events;

import io.github.niestrat99.advancedteleport.api.events.CancellableATEvent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ATTeleportEvent
extends CancellableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private final Player player;
    @NotNull
    private final Location fromLoc;
    @NotNull
    private final TeleportType type;
    @NotNull
    private final String locName;
    @NotNull
    private Location toLoc;

    @Contract(pure=true)
    public ATTeleportEvent(@NotNull Player player, @NotNull Location toLoc, @NotNull Location fromLoc, @NotNull String locName, @NotNull TeleportType type) {
        this.player = player;
        this.toLoc = toLoc;
        this.fromLoc = fromLoc;
        this.locName = locName;
        this.type = type;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public Location getFromLocation() {
        return this.fromLoc;
    }

    @Contract(pure=true)
    @NotNull
    public Location getToLocation() {
        return this.toLoc;
    }

    @Contract(pure=true)
    public void setToLocation(@NotNull Location toLoc) {
        this.toLoc = toLoc;
    }

    @Contract(pure=true)
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Contract(pure=true)
    @NotNull
    public TeleportType getType() {
        return this.type;
    }

    @Contract(pure=true)
    @NotNull
    public String getLocName() {
        return this.locName;
    }

    public static enum TeleportType {
        TPA(true, "tpa"),
        TPAHERE(true, "tpahere"),
        HOME(true, "home"),
        WARP(true, "warp"),
        SPAWN(true, "spawn"),
        TPR(false, "tpr"),
        BACK(true, "back"),
        TPLOC(false, "tploc");

        private final boolean restricted;
        private final String name;

        private TeleportType(boolean restricted, String name) {
            this.restricted = restricted;
            this.name = name;
        }

        @Contract(pure=true)
        public boolean isRestricted() {
            return this.restricted;
        }

        @Contract(pure=true)
        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

