/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.data;

import io.github.niestrat99.advancedteleport.api.data.ATException;
import io.github.niestrat99.advancedteleport.api.events.TrackableATEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CancelledEventException
extends ATException {
    @Contract(pure=true)
    private CancelledEventException(@Nullable CommandSender sender, @Nullable String message) {
        super(sender, message);
    }

    @Contract(pure=true)
    @NotNull
    public static CancelledEventException of(Cancellable event) {
        if (event instanceof TrackableATEvent) {
            TrackableATEvent atEvent = (TrackableATEvent)event;
            return new CancelledEventException(atEvent.getSender(), "The event " + event.getClass().getSimpleName() + " was cancelled.");
        }
        return new CancelledEventException(null, "The event " + event.getClass().getSimpleName() + " was cancelled.");
    }
}

