/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.NamedLocation;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.api.events.warps.WarpDeleteEvent;
import io.github.niestrat99.advancedteleport.api.events.warps.WarpMoveEvent;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Warp
implements NamedLocation {
    @Deprecated
    private static final HashMap<String, Warp> warps = new HashMap();
    @Nullable
    private final UUID creator;
    @NotNull
    private final String name;
    private final long createdTime;
    @NotNull
    private final String createdTimeFormatted;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private Location location;
    private long updatedTime;
    @NotNull
    private String updatedTimeFormatted;

    public Warp(@Nullable UUID creator, @NotNull String name, @NotNull Location location, long createdTime, long updatedTime) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The warp name must not be empty.");
        }
        this.name = name;
        this.location = location instanceof WorldlessLocation ? location : new WorldlessLocation(location, location.getWorld().getName());
        this.creator = creator;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        this.createdTimeFormatted = this.dateFormat.format(new Date(createdTime));
        this.updatedTimeFormatted = this.dateFormat.format(new Date(updatedTime));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    @Nullable
    public UUID getCreator() {
        return this.creator;
    }

    public CompletableFuture<Void> setLocation(@NotNull Location location) {
        return this.setLocation(location, null);
    }

    public CompletableFuture<Void> setLocation(@NotNull Location location, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new WarpMoveEvent(this, location, sender), event -> {
            this.location = event.getLocation();
            this.updatedTime = System.currentTimeMillis();
            this.updatedTimeFormatted = this.dateFormat.format(new Date(this.updatedTime));
            return CompletableFuture.runAsync(() -> WarpSQLManager.get().moveWarp(location, this.name), CoreClass.async);
        });
    }

    @Contract(pure=true)
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Contract(pure=true)
    public long getUpdatedTime() {
        return this.updatedTime;
    }

    @Contract(pure=true)
    @NotNull
    public String getCreatedTimeFormatted() {
        return this.createdTimeFormatted;
    }

    @Contract(pure=true)
    @NotNull
    public String getUpdatedTimeFormatted() {
        return this.updatedTimeFormatted;
    }

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<Void> delete() {
        return this.delete(null);
    }

    @NotNull
    public CompletableFuture<Void> delete(@Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new WarpDeleteEvent(this, sender), event -> {
            NamedLocationManager.get().removeWarp(this);
            return CompletableFuture.runAsync(() -> WarpSQLManager.get().removeWarp(this.name), CoreClass.async);
        });
    }

    @Deprecated
    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    static HashMap<String, Warp> warps() {
        return warps;
    }
}

