/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.NamedLocation;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.api.events.spawn.SpawnMirrorEvent;
import io.github.niestrat99.advancedteleport.api.events.spawn.SpawnMoveEvent;
import io.github.niestrat99.advancedteleport.api.events.spawn.SpawnRemoveEvent;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Spawn
implements NamedLocation {
    @NotNull
    private final String name;
    @Nullable
    private final UUID creator;
    @NotNull
    private Location location;
    @Nullable
    private Spawn mirroringSpawn;
    private final long createdTime;
    private long updatedTime;

    public Spawn(@NotNull String name, @NotNull Location location) {
        this(name, location, null);
    }

    public Spawn(@NotNull String name, @NotNull Location location, @Nullable UUID creator) {
        this(name, location, null, creator, System.currentTimeMillis(), System.currentTimeMillis());
    }

    public Spawn(@NotNull String name, @NotNull Location location, @Nullable Spawn mirroringSpawn, @Nullable UUID creator, long createdTime, long updatedTime) {
        this.name = name;
        this.location = location instanceof WorldlessLocation ? location : new WorldlessLocation(location, location.getWorld().getName());
        this.creator = creator;
        this.mirroringSpawn = mirroringSpawn;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    public CompletableFuture<Location> setLocation(@NotNull Location location, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new SpawnMoveEvent(this, location, sender), event -> {
            this.location = event.getNewLocation();
            this.updatedTime = System.currentTimeMillis();
            return SpawnSQLManager.get().moveSpawn(this).thenApplyAsync(result -> this.location);
        });
    }

    @Contract(pure=true)
    @Nullable
    public UUID getCreatorUUID() {
        return this.creator;
    }

    @Contract(pure=true)
    public boolean canAccess(Player teleportingPlayer) {
        return teleportingPlayer.hasPermission("at.member.spawn." + this.name);
    }

    @Contract(pure=true)
    @Nullable
    public Spawn getMirroringSpawn() {
        return this.mirroringSpawn;
    }

    @Contract(pure=true)
    public CompletableFuture<Spawn> setMirroringSpawn(@Nullable Spawn mirroringSpawn, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new SpawnMirrorEvent(this, mirroringSpawn, sender), event -> {
            this.mirroringSpawn = event.getDestinationSpawn();
            this.updatedTime = System.currentTimeMillis();
            NamedLocationManager.get().addMirroredSpawn(this.getName(), this.mirroringSpawn);
            return MetadataSQLManager.get().mirrorSpawn(this.getName(), event.getDestinationSpawn() == null ? null : event.getDestinationSpawn().getName()).thenApplyAsync(result -> this.mirroringSpawn);
        });
    }

    @Contract(pure=true)
    public CompletableFuture<Void> delete(@Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new SpawnRemoveEvent(this, sender), event -> {
            if (AdvancedTeleportAPI.getMainSpawn() == this) {
                return AdvancedTeleportAPI.setMainSpawn(null, sender).thenAcceptAsync(nullSpawn -> {
                    NamedLocationManager.get().removeSpawn(this);
                    SpawnSQLManager.get().removeSpawn(this.name).join();
                }, CoreClass.async);
            }
            NamedLocationManager.get().removeSpawn(this);
            return CompletableFuture.runAsync(() -> SpawnSQLManager.get().removeSpawn(this.name), CoreClass.async);
        });
    }

    @Contract(pure=true)
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Contract(pure=true)
    public long getUpdatedTime() {
        return this.updatedTime;
    }
}

