/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import com.google.common.collect.ImmutableMap;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.data.ATException;
import io.github.niestrat99.advancedteleport.api.events.CancellableATEvent;
import io.github.niestrat99.advancedteleport.api.events.spawn.SpawnCreateEvent;
import io.github.niestrat99.advancedteleport.api.events.spawn.SpawnPostCreateEvent;
import io.github.niestrat99.advancedteleport.api.events.spawn.SwitchMainSpawnEvent;
import io.github.niestrat99.advancedteleport.api.events.warps.WarpCreateEvent;
import io.github.niestrat99.advancedteleport.api.events.warps.WarpPostCreateEvent;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.managers.RTPManager;
import io.github.niestrat99.advancedteleport.managers.SignManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import io.github.niestrat99.advancedteleport.utilities.RandomTPAlgorithms;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvancedTeleportAPI {
    private AdvancedTeleportAPI() {
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull OfflinePlayer> getOfflinePlayer(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> Bukkit.getOfflinePlayer((String)name), CoreClass.async);
    }

    @NotNull
    public static CompletableFuture<Warp> setWarp(@NotNull String name, @Nullable CommandSender creator, @NotNull Location location) {
        Objects.requireNonNull(location, "The warp location must not be null.");
        if (!location.isWorldLoaded()) {
            return ATException.failedFuture("The world the warp is being set in must be loaded.");
        }
        return AdvancedTeleportAPI.validateEvent(new WarpCreateEvent(name, creator, location), event -> {
            Warp warp = new Warp(AdvancedTeleportAPI.maybePlayer(event.getSender()).map(OfflinePlayer::getUniqueId).orElse(null), event.getName(), event.getLocation(), System.currentTimeMillis(), System.currentTimeMillis());
            NamedLocationManager.get().registerWarp(warp);
            return CompletableFuture.runAsync(() -> WarpSQLManager.get().addWarp(warp)).thenApplyAsync(ignored -> {
                WarpPostCreateEvent postCreateEvent = new WarpPostCreateEvent(warp);
                Bukkit.getServer().getPluginManager().callEvent((Event)postCreateEvent);
                return warp;
            }, CoreClass.sync);
        });
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends CancellableATEvent, R> CompletableFuture<R> validateEvent(@NotNull T event, @NotNull Function<T, CompletableFuture<R>> validatedEvent) {
        if (event.callEvent()) {
            return validatedEvent.apply(event);
        }
        return ATException.failedFuture(event);
    }

    @NotNull
    static Optional<Player> maybePlayer(@Nullable CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    @Nullable
    public static Warp getWarp(@NotNull String name) {
        Objects.requireNonNull(name, "The warp name must not be null.");
        return (Warp)AdvancedTeleportAPI.getWarps().get((Object)name);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableMap<String, Warp> getWarps() {
        return NamedLocationManager.get().getWarps();
    }

    public static boolean isWarpSet(@NotNull String name) {
        Objects.requireNonNull(name, "The warp name must not be null.");
        return AdvancedTeleportAPI.getWarps().containsKey((Object)name);
    }

    @NotNull
    public static CompletableFuture<Spawn> setSpawn(@NotNull String name, @Nullable CommandSender sender, @NotNull Location location) {
        Objects.requireNonNull(location, "The spawn location must not be null.");
        if (!location.isWorldLoaded()) {
            return ATException.failedFuture(location.getWorld(), "The world the spawn is being set in must be loaded.");
        }
        return AdvancedTeleportAPI.validateEvent(new SpawnCreateEvent(name, sender, location), event -> {
            Spawn spawn = new Spawn(name, location, AdvancedTeleportAPI.maybePlayer(event.getSender()).map(OfflinePlayer::getUniqueId).orElse(null));
            NamedLocationManager.get().registerSpawn(spawn);
            if (NamedLocationManager.get().getMainSpawn() == null) {
                Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> AdvancedTeleportAPI.setMainSpawn(spawn, sender));
            }
            return SpawnSQLManager.get().addSpawn(spawn).thenApplyAsync(x -> {
                Bukkit.getPluginManager().callEvent((Event)new SpawnPostCreateEvent(spawn));
                return spawn;
            }, CoreClass.sync);
        });
    }

    @NotNull
    public static CompletableFuture<Spawn> setMainSpawn(@Nullable Spawn newSpawn, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new SwitchMainSpawnEvent(AdvancedTeleportAPI.getMainSpawn(), newSpawn, sender), event -> CompletableFuture.supplyAsync(() -> {
            NamedLocationManager.get().setMainSpawn(event.getNewMainSpawn());
            MetadataSQLManager.get().deleteMainSpawn().join();
            if (event.getNewMainSpawn() != null) {
                MetadataSQLManager.get().addSpawnMetadata(event.getNewMainSpawn().getName(), "main_spawn", "true");
            }
            return event.getNewMainSpawn();
        }));
    }

    @Nullable
    public static Spawn getSpawn(@NotNull String name) {
        return NamedLocationManager.get().getSpawn(name);
    }

    @NotNull
    public static Spawn getSpawn(@NotNull World world) {
        return AdvancedTeleportAPI.getDestinationSpawn(world, null);
    }

    @NotNull
    public static Spawn getDestinationSpawn(@NotNull World world, @Nullable Player player) {
        return NamedLocationManager.get().getSpawn(world, player);
    }

    @Nullable
    public static Spawn getMainSpawn() {
        return NamedLocationManager.get().getMainSpawn();
    }

    @NotNull
    public static ImmutableMap<String, Spawn> getSpawns() {
        return NamedLocationManager.get().getSpawns();
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Location> getRandomLocation(@NotNull World world, @NotNull Player player) {
        if (MainConfig.get().RAPID_RESPONSE.get().booleanValue() && PaperLib.isPaper()) {
            Location nextLoc = RTPManager.getLocationUrgently(world);
            if (nextLoc != null) {
                return CompletableFuture.completedFuture(nextLoc);
            }
            return RTPManager.getNextAvailableLocation(world);
        }
        return CompletableFuture.supplyAsync(() -> RandomTPAlgorithms.getAlgorithms().get("binary").fire(player, world), CoreClass.async);
    }

    @Nullable
    public static ATSign getSign(@NotNull String sign) {
        return SignManager.get().getSign(sign);
    }

    @Nullable
    public static ATSign getSignByDisplayName(@NotNull Component component) {
        return SignManager.get().getSignByDisplayName(component);
    }

    @Nullable
    public static ATSign getSignByFlatDisplayName(@NotNull TextComponent component) {
        return SignManager.get().getSignByFlatDisplayName(component);
    }

    @Nullable
    public static ATSign getSignByLegacyName(@NotNull String string) {
        return SignManager.get().getSignByDisplayName((Component)LegacyComponentSerializer.legacySection().deserialize(string));
    }

    public static void registerSign(@NotNull String name, @NotNull ATSign sign) {
        SignManager.get().register(name, sign);
    }
}

