/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import com.google.common.collect.ImmutableMap;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.BlockInfo;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.data.CancelledEventException;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.api.events.homes.HomeCreateEvent;
import io.github.niestrat99.advancedteleport.api.events.homes.HomeDeleteEvent;
import io.github.niestrat99.advancedteleport.api.events.homes.SwitchMainHomeEvent;
import io.github.niestrat99.advancedteleport.api.events.players.PreviousLocationChangeEvent;
import io.github.niestrat99.advancedteleport.api.events.players.ToggleTeleportationEvent;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.managers.InvulnerabilityManager;
import io.github.niestrat99.advancedteleport.managers.MovementManager;
import io.github.niestrat99.advancedteleport.managers.ParticleManager;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import io.github.niestrat99.advancedteleport.sql.BlocklistManager;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.PlayerSQLManager;
import io.papermc.paper.entity.TeleportFlag;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ATPlayer {
    @NotNull
    private static final HashMap<String, ATPlayer> players = new HashMap();
    @NotNull
    protected WeakReference<OfflinePlayer> player;
    @NotNull
    protected UUID uuid;
    @NotNull
    protected String name;
    @NotNull
    private final @NotNull PendingData<LinkedHashMap<String, @NotNull Home>> homes;
    @NotNull
    private final @NotNull PendingData<HashMap<UUID, @NotNull BlockInfo>> blockedUsers;
    @NotNull
    private final PendingData<Boolean> isTeleportationEnabled;
    private final @NotNull PendingData<@Nullable String> mainHome;
    private final @NotNull PendingData<@Nullable Location> previousLoc;

    public ATPlayer(@NotNull Player player) {
        this((OfflinePlayer)player, player.getName(), player.getUniqueId());
    }

    @ApiStatus.Internal
    public ATPlayer(@NotNull OfflinePlayer player, @NotNull String name, @NotNull UUID uuid) {
        this.player = new WeakReference<OfflinePlayer>(player);
        this.uuid = uuid;
        this.name = name;
        this.homes = new PendingData(CompletableFuture.supplyAsync(() -> HomeSQLManager.get().getHomes(uuid.toString()), CoreClass.async).thenApplyAsync(list -> list, CoreClass.async));
        this.mainHome = new PendingData(CompletableFuture.supplyAsync(() -> PlayerSQLManager.get().getMainHome(name), CoreClass.async).thenApplyAsync(home -> {
            this.reorganiseHomes();
            return home;
        }, CoreClass.async));
        this.blockedUsers = new PendingData<HashMap>(CompletableFuture.supplyAsync(() -> BlocklistManager.get().getBlockedPlayers(uuid.toString()), CoreClass.async));
        this.previousLoc = new PendingData<Location>(CompletableFuture.supplyAsync(() -> PlayerSQLManager.get().getPreviousLocation(name), CoreClass.async));
        this.isTeleportationEnabled = new PendingData<Boolean>(CompletableFuture.supplyAsync(() -> PlayerSQLManager.get().isTeleportationOn(uuid), CoreClass.async));
        players.put(name.toLowerCase(), this);
    }

    @Contract(pure=true)
    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Objects.requireNonNullElseGet((OfflinePlayer)this.player.get(), () -> Bukkit.getOfflinePlayer((UUID)this.uuid));
    }

    @Contract(pure=true)
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Deprecated
    @ApiStatus.Internal
    public void teleport(ATTeleportEvent event, String command, String teleportMsg, int warmUp) {
        this.teleport(event, command, teleportMsg);
    }

    @ApiStatus.Internal
    public void teleport(@NotNull ATTeleportEvent event, @NotNull String command, @NotNull String teleportMsg) {
        Player player = event.getPlayer();
        int warmUp = this.getWarmUp(command, event.getToLocation().getWorld());
        if (event.isCancelled()) {
            return;
        }
        if (event.getToLocation().getWorld() == null) {
            CustomMessages.sendMessage((CommandSender)player, "Error.worldUnloaded", new TagResolver[0]);
            return;
        }
        if (!PaymentManager.getInstance().canPay(command, player, event.getToLocation().getWorld())) {
            return;
        }
        String cooldownConfig = MainConfig.get().APPLY_COOLDOWN_AFTER.get();
        if (cooldownConfig.equalsIgnoreCase("request") || cooldownConfig.equalsIgnoreCase("accept")) {
            CooldownManager.addToCooldown(command, player, event.getToLocation().getWorld());
        }
        if (warmUp > 0 && !player.hasPermission("at.admin.bypass.timer")) {
            MovementManager.createMovementTimer(player, event.getToLocation(), command, teleportMsg, warmUp, new TagResolver[]{Placeholder.unparsed((String)"home", (String)event.getLocName()), Placeholder.unparsed((String)"warp", (String)event.getLocName())});
        } else {
            ParticleManager.onPreTeleport(player, command);
            ATPlayer.teleportWithOptions(player, event.getToLocation(), PlayerTeleportEvent.TeleportCause.COMMAND).whenComplete((result, err) -> {
                if (!result.booleanValue()) {
                    CustomMessages.sendMessage((CommandSender)player, "Error.teleportFailed", new TagResolver[0]);
                    return;
                }
                CustomMessages.sendMessage((CommandSender)player, teleportMsg, new TagResolver[]{Placeholder.unparsed((String)"home", (String)event.getLocName()), Placeholder.unparsed((String)"warp", (String)event.getLocName())});
                PaymentManager.getInstance().withdraw(command, player, event.getToLocation().getWorld());
                InvulnerabilityManager.createInvulnerability(player, this.getInvulnerability(command, event.getToLocation().getWorld()));
                ParticleManager.onPostTeleport(player, command);
                if (MainConfig.get().APPLY_COOLDOWN_AFTER.get().equalsIgnoreCase("teleport")) {
                    CooldownManager.addToCooldown(command, player, event.getToLocation().getWorld());
                }
            });
        }
    }

    @ApiStatus.Internal
    public static CompletableFuture<Boolean> teleportWithOptions(@NotNull Player player, @NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        try {
            @NotNull ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
            TeleportFlag.EntityState> flags = new ArrayList<TeleportFlag.EntityState>();
            if (MainConfig.get().RETAIN_PASSENGERS.get().booleanValue() && !player.getPassengers().isEmpty()) {
                flags.add(TeleportFlag.EntityState.RETAIN_PASSENGERS);
            }
            if (MainConfig.get().RETAIN_VEHICLES.get().booleanValue() && player.getVehicle() != null) {
                if (MainConfig.get().RETAIN_LIVING_ONLY.get().booleanValue()) {
                    if (player.getVehicle() instanceof LivingEntity) {
                        flags.add(TeleportFlag.EntityState.RETAIN_VEHICLE);
                    }
                } else {
                    flags.add(TeleportFlag.EntityState.RETAIN_VEHICLE);
                }
            }
            if (!flags.isEmpty()) {
                return CompletableFuture.completedFuture(player.teleport(location, cause, flags.toArray(new TeleportFlag[0])));
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        return PaperLib.teleportAsync((Entity)player, (Location)location, (PlayerTeleportEvent.TeleportCause)cause);
    }

    @Contract(pure=true)
    public boolean isTeleportationEnabled() {
        return Boolean.TRUE.equals(this.isTeleportationEnabled.data);
    }

    @Contract(pure=true)
    @Nullable
    public Player getPlayer() {
        OfflinePlayer offlinePlayer = (OfflinePlayer)this.player.get();
        if (offlinePlayer == null) {
            return Bukkit.getPlayer((UUID)this.uuid);
        }
        return offlinePlayer.getPlayer();
    }

    @NotNull
    public CompletableFuture<Void> setTeleportationEnabled(boolean teleportationEnabled) {
        return this.setTeleportationEnabled(teleportationEnabled, null);
    }

    @NotNull
    public CompletableFuture<Void> setTeleportationEnabled(boolean teleportationEnabled, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new ToggleTeleportationEvent(sender, this.getOfflinePlayer(), teleportationEnabled, this.isTeleportationEnabled() ^ teleportationEnabled), event -> {
            this.isTeleportationEnabled.data = event.isEnabled();
            return CompletableFuture.runAsync(() -> PlayerSQLManager.get().setTeleportationOn(this.uuid, teleportationEnabled), CoreClass.async);
        });
    }

    @Contract(pure=true)
    public boolean hasBlocked(@NotNull OfflinePlayer otherPlayer) {
        return this.hasBlocked(otherPlayer.getUniqueId());
    }

    @Contract(pure=true)
    public boolean hasBlocked(@NotNull UUID otherPlayer) {
        return this.blockedUsers.data != null && ((HashMap)this.blockedUsers.data).containsKey(otherPlayer);
    }

    @Contract(pure=true)
    @Nullable
    public BlockInfo getBlockInfo(@NotNull OfflinePlayer otherPlayer) {
        return this.blockedUsers.data != null ? (BlockInfo)((HashMap)this.blockedUsers.data).get(otherPlayer.getUniqueId()) : null;
    }

    @NotNull
    public CompletableFuture<Void> blockUser(@NotNull OfflinePlayer otherPlayer) {
        return this.blockUser(otherPlayer.getUniqueId(), null);
    }

    @NotNull
    public CompletableFuture<Void> blockUser(@NotNull UUID otherUUID, @Nullable String reason) {
        this.blockedUsers.getData().thenApplyAsync(list -> list.put(otherUUID, new BlockInfo(this.uuid, otherUUID, reason, System.currentTimeMillis())));
        return CompletableFuture.runAsync(() -> BlocklistManager.get().blockUser(this.uuid.toString(), otherUUID.toString(), reason), CoreClass.async);
    }

    @NotNull
    public CompletableFuture<Void> blockUser(@NotNull OfflinePlayer otherPlayer, @Nullable String reason) {
        return this.blockUser(otherPlayer.getUniqueId(), reason);
    }

    @NotNull
    public CompletableFuture<Void> unblockUser(@NotNull UUID otherUUID) {
        this.blockedUsers.getData().thenApplyAsync(list -> (BlockInfo)list.remove(otherUUID));
        return CompletableFuture.runAsync(() -> BlocklistManager.get().unblockUser(this.uuid.toString(), otherUUID.toString()), CoreClass.async);
    }

    @Contract(pure=true)
    @NotNull
    public ImmutableMap<String, Home> getHomes() {
        return this.getHomes(true);
    }

    @Contract(pure=true)
    @NotNull
    public ImmutableMap<String, Home> getHomes(boolean withBed) {
        HashMap map = this.homes.data == null ? new HashMap() : (HashMap)this.homes.data;
        Home bedSpawn = this.getBedSpawn();
        if (withBed && bedSpawn != null && MainConfig.get().ADD_BED_TO_HOMES.get().booleanValue()) {
            map.put("bed", bedSpawn);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<ImmutableMap<String, Home>> getHomesAsync() {
        return this.homes.getData().thenApplyAsync(ImmutableMap::copyOf);
    }

    @NotNull
    public CompletableFuture<Void> addHome(@NotNull String name, @NotNull Location location) {
        return this.addHome(name, location, this.getPlayer(), true);
    }

    @NotNull
    public CompletableFuture<Void> addHome(@NotNull String name, @NotNull Location location, @NotNull Player creator) {
        return this.addHome(name, location, creator, true);
    }

    @NotNull
    public CompletableFuture<Void> addHome(@NotNull String name, @NotNull Location location, @Nullable Player creator, boolean async) {
        if (this.hasHome(name)) {
            return this.moveHome(name, location);
        }
        return AdvancedTeleportAPI.validateEvent(new HomeCreateEvent(this.getOfflinePlayer(), name, location, creator), event -> {
            this.homes.getData().thenApplyAsync(list -> {
                list.put(name, new Home(event.getPlayer().getUniqueId(), event.getName(), event.getLocation(), System.currentTimeMillis(), System.currentTimeMillis()));
                this.homes.data = list;
                return list;
            });
            return CompletableFuture.runAsync(() -> HomeSQLManager.get().addHome(location, this.uuid, name, async), CoreClass.async);
        });
    }

    public boolean hasHome(@NotNull String name) {
        return this.homes.data != null && ((LinkedHashMap)this.homes.data).containsKey(name);
    }

    @NotNull
    public CompletableFuture<Void> moveHome(@NotNull String name, @NotNull Location newLocation) {
        return this.moveHome(name, newLocation, null);
    }

    @NotNull
    public CompletableFuture<Void> moveHome(@NotNull String name, @NotNull Location newLocation, @Nullable CommandSender sender) {
        return ((CompletableFuture)this.homes.getData().thenApplyAsync(homes -> {
            Home home = (Home)homes.get(name);
            if (home == null) {
                throw new NullPointerException("Context [%s] | Message [%s]".formatted(sender, "Missing home: " + name));
            }
            return home;
        }, CoreClass.sync)).thenAcceptAsync(home -> home.move(newLocation, sender), CoreClass.sync);
    }

    @NotNull
    public CompletableFuture<Void> removeHome(@NotNull String name) {
        return this.removeHome(name, null);
    }

    @NotNull
    public CompletableFuture<Void> removeHome(@NotNull String name, @Nullable CommandSender sender) {
        return ((CompletableFuture)this.homes.getData().thenApplyAsync(list -> {
            Home home = (Home)list.get(name);
            if (home == null) {
                return null;
            }
            HomeDeleteEvent event = new HomeDeleteEvent(home, sender);
            if (!event.callEvent()) {
                throw new RuntimeException(CancelledEventException.of(event));
            }
            list.remove(event.getHome().getName());
            this.homes.data = list;
            return event.getHome();
        }, CoreClass.sync)).thenAcceptAsync(home -> {
            if (home == null) {
                return;
            }
            HomeSQLManager.get().removeHome(this.uuid, home.getName());
        }, CoreClass.async);
    }

    @Contract(pure=true)
    @Nullable
    public Home getHome(@NotNull String name) {
        return this.homes.data == null ? null : (Home)((LinkedHashMap)this.homes.data).get(name);
    }

    @Contract(pure=true)
    @Nullable
    public Home getBedSpawn() {
        if (this.getOfflinePlayer().getBedSpawnLocation() != null) {
            return new Home(this.uuid, "bed", this.getOfflinePlayer().getBedSpawnLocation(), -1L, -1L);
        }
        return null;
    }

    @Contract(pure=true)
    public boolean hasMainHome() {
        return this.homes.data != null && this.mainHome.data != null && ((LinkedHashMap)this.homes.data).containsKey(this.mainHome.data);
    }

    @Contract(pure=true)
    @Nullable
    public Home getMainHome() {
        if (this.homes.data == null || this.mainHome.data == null) {
            return null;
        }
        return (Home)((LinkedHashMap)this.homes.data).get(this.mainHome.data);
    }

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<Void> setMainHome(@NotNull String name) {
        return this.setMainHome(name, null);
    }

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<Void> setMainHome(@NotNull String name, @Nullable CommandSender sender) {
        return this.homes.getData().thenAcceptAsync(list -> {
            Home home = (Home)list.get(name);
            if (home == null) {
                throw new NullPointerException("Context [%s] | Message [%s]".formatted(sender, "Missing home: " + name));
            }
            this.reorganiseHomes();
            SwitchMainHomeEvent event = new SwitchMainHomeEvent(this.mainHome.data == null ? null : (Home)list.get(this.mainHome.data), home, sender);
            if (!event.callEvent()) {
                return;
            }
            this.mainHome.data = event.getNewMainHome().getName();
            PlayerSQLManager.get().setMainHome(this.uuid, event.getNewMainHome().getName());
        }, CoreClass.sync);
    }

    private void reorganiseHomes() {
        this.homes.getData().thenAcceptAsync(homes -> {
            LinkedHashMap homesList = homes;
            this.mainHome.getData().thenAcceptAsync(mainHome -> {
                if (!homesList.containsKey(mainHome)) {
                    return;
                }
                LinkedHashMap<String, Home> tempHomes = new LinkedHashMap<String, Home>();
                tempHomes.put((String)mainHome, (Home)homesList.get(mainHome));
                homesList.keySet().stream().filter(home -> !home.equals(mainHome)).forEach(home -> tempHomes.put((String)home, (Home)homes.get(home)));
                this.homes.data = tempHomes;
                this.mainHome.data = mainHome;
            });
        });
    }

    public int getHomesLimit() {
        int maxHomes = MainConfig.get().DEFAULT_HOMES_LIMIT.get();
        boolean worldSpecific = false;
        if (this.getPlayer() == null) {
            return -1;
        }
        for (PermissionAttachmentInfo permission : this.getPlayer().getEffectivePermissions()) {
            int homes;
            if (!permission.getValue() || !permission.getPermission().startsWith("at.member.homes.")) continue;
            String perm = permission.getPermission();
            String endNode = perm.substring("at.member.homes.".length());
            if (endNode.lastIndexOf(".") != -1) {
                String[] data = endNode.split("\\.");
                if (data[0].equals(this.getPlayer().getWorld().getName()) && data[1].matches("^\\d+$")) {
                    int homes2 = Integer.parseInt(data[1]);
                    if (!worldSpecific) {
                        maxHomes = homes2;
                        worldSpecific = true;
                    } else if (maxHomes < homes2) {
                        maxHomes = homes2;
                    }
                }
            } else if (worldSpecific) continue;
            if (endNode.equalsIgnoreCase("unlimited")) {
                return -1;
            }
            if (!endNode.matches("^\\d+$") || maxHomes >= (homes = Integer.parseInt(endNode))) continue;
            maxHomes = homes;
        }
        return maxHomes;
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getCooldown(@NotNull String command, @NotNull World destinationWorld) {
        return this.getMin("at.member.cooldown", command, MainConfig.get().CUSTOM_COOLDOWNS.get(), destinationWorld, MainConfig.get().COOLDOWNS.valueOf(command).get());
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getInvulnerability(@NotNull String command, @NotNull World destinationWorld) {
        return this.determineValue("at.member.invulnerability", command, MainConfig.get().COMMAND_INVULNERABILITY_DURATIONS.valueOf(command).get(), MainConfig.get().CUSTOM_INVULNERABILITY_DURATIONS.get(), destinationWorld, Math::max);
    }

    @Deprecated
    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getCooldown(@NotNull String command) {
        return this.getCooldown(command, this.getPlayer().getWorld());
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getWarmUp(@NotNull String command, @NotNull World destinationWorld) {
        return this.getMin("at.member.timer", command, MainConfig.get().CUSTOM_WARM_UPS.get(), destinationWorld, MainConfig.get().WARM_UPS.valueOf(command).get());
    }

    @Deprecated
    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getWarmUp(@NotNull String command) {
        return this.getWarmUp(command, this.getPlayer().getWorld());
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getDistanceLimitation(@Nullable String command, @NotNull World destinationWorld) {
        return this.determineValue("at.member.distance", command, command == null ? MainConfig.get().MAXIMUM_TELEPORT_DISTANCE.get() : MainConfig.get().DISTANCE_LIMITS.valueOf(command).get(), MainConfig.get().CUSTOM_DISTANCE_LIMITS.get(), destinationWorld, Math::max);
    }

    @Deprecated
    @Contract(pure=true)
    public int getDistanceLimitation(@Nullable String command) {
        return this.getDistanceLimitation(command, this.getPlayer().getWorld());
    }

    @Contract(pure=true)
    private @Range(from=0L, to=0x7FFFFFFFL) int getMin(@NotNull String permission, @Nullable String command, @NotNull ConfigSection customSection, @NotNull World world, int defaultValue) {
        return this.determineValue(permission, command, defaultValue, customSection, world, Math::min);
    }

    @Contract(pure=true)
    private @Range(from=0L, to=0x7FFFFFFFL) int determineValue(@NotNull String permission, @Nullable String command, int defaultValue, @NotNull ConfigSection customSection, @NotNull World world, @NotNull BiFunction<Integer, Integer, Integer> consumer) {
        List<Object> cooldowns = new ArrayList();
        if (this.getPlayer() == null) {
            return defaultValue;
        }
        for (String key : customSection.getKeys(false)) {
            String value = customSection.getString(key);
            String string = world.getName().toLowerCase(Locale.ENGLISH);
            if (!this.getPlayer().hasPermission(permission + "." + key) && !this.getPlayer().hasPermission(permission + "." + command + "." + key) && !this.getPlayer().hasPermission(permission + "." + string + "." + key) && !this.getPlayer().hasPermission(permission + "." + command + "." + string + "." + key)) continue;
            cooldowns.clear();
            cooldowns.add(value);
        }
        if (cooldowns.isEmpty()) {
            if (command == null) {
                cooldowns = this.getDynamicPermission(permission);
            } else {
                cooldowns = this.getDynamicPermission(permission + "." + command);
                if (cooldowns.isEmpty()) {
                    cooldowns = this.getDynamicPermission(permission);
                }
            }
        } else {
            return Integer.parseInt((String)cooldowns.get(0));
        }
        int min = defaultValue;
        boolean changed = false;
        for (String string : cooldowns) {
            if (!string.matches("^\\d+$")) continue;
            if (!changed) {
                min = Integer.parseInt(string);
                changed = true;
                continue;
            }
            min = consumer.apply(min, Integer.parseInt(string));
        }
        return min;
    }

    @NotNull
    private List<String> getDynamicPermission(@NotNull String rawPrefix) {
        Object prefix;
        Object object = prefix = rawPrefix.endsWith(".") ? rawPrefix : rawPrefix + ".";
        if (this.getPlayer() == null) {
            return new ArrayList<String>();
        }
        boolean worldSpecific = false;
        ArrayList<String> results = new ArrayList<String>();
        for (PermissionAttachmentInfo permission : this.getPlayer().getEffectivePermissions()) {
            if (!permission.getValue() || !permission.getPermission().startsWith((String)prefix)) continue;
            String perm = permission.getPermission();
            String endNode = perm.substring(((String)prefix).length());
            if (endNode.lastIndexOf(".") != -1) {
                String[] data = endNode.split("\\.");
                if (data[0].equals(this.getPlayer().getWorld().getName())) {
                    if (!worldSpecific) {
                        results.clear();
                    }
                    worldSpecific = true;
                    results.add(data[1]);
                }
            } else if (worldSpecific) continue;
            results.add(endNode);
        }
        return results;
    }

    public boolean canAccessHome(@NotNull Home home) {
        if (this.getHomesLimit() == -1) {
            return true;
        }
        if (!MainConfig.get().DENY_HOMES_IF_OVER_LIMIT.get().booleanValue()) {
            return true;
        }
        if (this.homes.data != null && ((LinkedHashMap)this.homes.data).containsValue(home)) {
            ArrayList homes = new ArrayList(((LinkedHashMap)this.homes.data).values());
            int index = homes.indexOf(home);
            return index < this.getHomesLimit();
        }
        return false;
    }

    public boolean canSetMoreHomes() {
        return this.getHomesLimit() == -1 || this.homes.data != null && ((LinkedHashMap)this.homes.data).size() < this.getHomesLimit();
    }

    @NotNull
    public static ATPlayer getPlayer(@NotNull Player player) {
        if (players.containsKey(player.getName().toLowerCase())) {
            return players.get(player.getName().toLowerCase());
        }
        if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue() && PluginHookManager.get().floodgateEnabled()) {
            FloodgateApi api = FloodgateApi.getInstance();
            if (api == null) {
                CoreClass.getInstance().getLogger().severe("Detected the floodgate plugin, but it seems to be out of date. Please use floodgate v2.");
                return new ATPlayer(player);
            }
            if (api.isFloodgateId(player.getUniqueId())) {
                return new ATFloodgatePlayer(player);
            }
        }
        return new ATPlayer(player);
    }

    @NotNull
    public static ATPlayer getPlayer(@NotNull OfflinePlayer player) {
        String name = player.getName();
        Objects.requireNonNull(name, "Player name must not be null.");
        Objects.requireNonNull(player.getUniqueId(), "Player UUID must not be null.");
        return players.containsKey(name.toLowerCase()) ? players.get(name.toLowerCase()) : new ATPlayer(player, name, player.getUniqueId());
    }

    @Nullable
    public static ATPlayer getPlayer(@NotNull String name) {
        if (players.containsKey(name.toLowerCase())) {
            return players.get(name.toLowerCase());
        }
        AdvancedTeleportAPI.getOfflinePlayer(name).whenComplete((player, err) -> new ATPlayer((OfflinePlayer)player, name, player.getUniqueId()));
        return null;
    }

    @NotNull
    public static CompletableFuture<ATPlayer> getPlayerFuture(@NotNull String name) {
        if (players.containsKey(name.toLowerCase())) {
            return CompletableFuture.completedFuture(players.get(name.toLowerCase()));
        }
        return AdvancedTeleportAPI.getOfflinePlayer(name).thenApplyAsync(player -> new ATPlayer((OfflinePlayer)player, name, player.getUniqueId()), CoreClass.sync);
    }

    public static void relog(@NotNull Player player) {
        if (players.containsKey(player.getName().toLowerCase())) {
            ATPlayer currentPlayer = players.get(player.getName().toLowerCase());
            currentPlayer.player = new WeakReference<Player>(player);
            currentPlayer.uuid = player.getUniqueId();
            return;
        }
        ATPlayer.getPlayer(player);
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public static void removePlayer(@NotNull Player player) {
        players.remove(player.getName());
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public static boolean isPlayerCached(@NotNull String name) {
        return players.containsKey(name.toLowerCase());
    }

    @Contract(pure=true)
    @Nullable
    public Location getPreviousLocation() {
        return (Location)this.previousLoc.data;
    }

    @NotNull
    public CompletableFuture<Void> setPreviousLocation(@NotNull Location previousLoc) {
        return AdvancedTeleportAPI.validateEvent(new PreviousLocationChangeEvent(this.getOfflinePlayer(), previousLoc, (Location)this.previousLoc.data), event -> {
            this.previousLoc.data = event.getNewLocation();
            return CompletableFuture.runAsync(() -> PlayerSQLManager.get().setPreviousLocation(this.getOfflinePlayer().getName(), previousLoc));
        });
    }

    private static class PendingData<T> {
        private final CompletableFuture<T> future;
        @Nullable
        private T data;

        public PendingData(CompletableFuture<T> future) {
            this.future = future;
            this.future.thenApplyAsync(data -> {
                this.data = data;
                return this.data;
            });
        }

        public CompletableFuture<T> getFuture() {
            return this.future;
        }

        public CompletableFuture<T> getData() {
            if (this.data != null) {
                return CompletableFuture.completedFuture(this.data);
            }
            return this.future;
        }
    }
}

