/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ATFloodgatePlayer
extends ATPlayer {
    @NotNull
    private final UUID floodgateUuid;

    @Contract(pure=true)
    ATFloodgatePlayer(@NotNull Player player) throws IllegalStateException {
        super(player);
        if (!PluginHookManager.get().floodgateEnabled()) {
            throw new IllegalStateException("Floodgate is not enabled.");
        }
        this.floodgateUuid = FloodgateApi.getInstance().getPlayer(player.getUniqueId()).getCorrectUniqueId();
    }

    public void sendTPAForm(boolean here) {
        if (here) {
            this.sendDropdownForm("tpahere", this.getVisiblePlayerNames());
        } else {
            this.sendDropdownForm("tpa", this.getVisiblePlayerNames());
        }
    }

    private void sendDropdownForm(@NotNull String command, @NotNull Collection<String> inputs) {
        String[] items = new String[inputs.size()];
        int index = 0;
        for (String input : inputs) {
            items[index++] = input;
        }
        if (this.getPlayer() == null) {
            CoreClass.getInstance().getLogger().warning("This player with the UUID " + String.valueOf(this.uuid) + " is null, WHY?");
            return;
        }
        CustomForm form = (CustomForm)((CustomForm.Builder)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title(CustomMessages.asString("Forms." + command + "-title"))).dropdown(CustomMessages.asString("Forms." + command + "-description"), items).closedOrInvalidResultHandler(() -> CustomMessages.sendMessage((CommandSender)this.getPlayer(), "Error.noPlayerInput", new TagResolver[0]))).validResultHandler(response -> {
            int i = response.asDropdown();
            String result = items[i];
            this.getPlayer().performCommand("advancedteleport:" + command + " " + result);
        })).build();
        FloodgateApi.getInstance().sendForm(this.floodgateUuid, (Form)form);
    }

    @Contract(pure=true)
    @NotNull
    public List<String> getVisiblePlayerNames() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> player != this.getPlayer()).filter(player -> this.getPlayer().canSee(player)).filter(player -> {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            return !atPlayer.hasBlocked((OfflinePlayer)this.getPlayer()) && !this.hasBlocked(atPlayer.uuid());
        }).map(Player::getName).toList();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.floodgateUuid);
    }

    public void sendRequestFormTPA(@NotNull Player sender) {
        SimpleForm.Builder form = ((SimpleForm.Builder)SimpleForm.builder().title(CustomMessages.asString("Forms.tpa-received-title"))).content(CustomMessages.asString("Forms.tpa-received-description", new TagResolver[]{Placeholder.unparsed((String)"player", (String)sender.getDisplayName())})).button(CustomMessages.asString("Forms.tpa-received-accept")).button(CustomMessages.asString("Forms.tpa-received-deny"));
        this.sendRequest(sender, form, true);
    }

    private void sendRequest(@NotNull Player sender, @NotNull SimpleForm.Builder form, boolean tpa) {
        if (this.getPlayer() == null) {
            CoreClass.getInstance().getLogger().warning("This player with the UUID " + String.valueOf(this.uuid) + " is null, WHY?");
            return;
        }
        form.closedOrInvalidResultHandler(() -> CustomMessages.sendMessage((CommandSender)this.getPlayer(), tpa ? "Info.tpaRequestReceived" : "Info.tpaRequestHere", new TagResolver[]{Placeholder.parsed((String)"player", (String)MiniMessage.miniMessage().escapeTags(sender.getName())), Placeholder.unparsed((String)"lifetime", (String)String.valueOf(MainConfig.get().REQUEST_LIFETIME.get()))}));
        form.validResultHandler(response -> this.getPlayer().performCommand(response.clickedButtonId() == 0 ? "advancedteleport:tpyes " + sender.getName() : "advancedteleport:tpno " + sender.getName()));
        FloodgateApi.getInstance().sendForm(this.floodgateUuid, (FormBuilder)form);
    }

    public void sendRequestFormTPAHere(@NotNull Player sender) {
        SimpleForm.Builder form = ((SimpleForm.Builder)SimpleForm.builder().title(CustomMessages.asString("Forms.tpahere-received-title"))).content(CustomMessages.asString("Forms.tpahere-received-description", new TagResolver[]{Placeholder.unparsed((String)"player", (String)sender.getDisplayName())})).button(CustomMessages.asString("Forms.tpahere-received-accept")).button(CustomMessages.asString("Forms.tpahere-received-deny"));
        this.sendRequest(sender, form, false);
    }

    public void sendHomeForm() {
        this.sendDropdownForm("home", (Collection<String>)this.getHomes().keySet());
    }

    public void sendSetHomeForm() {
        this.sendInputForm("sethome", "Error.noHomeInput");
    }

    private void sendInputForm(@NotNull String command, @NotNull String errorMessage) {
        if (this.getPlayer() == null) {
            CoreClass.getInstance().getLogger().warning("This player with the UUID " + String.valueOf(this.uuid) + " is null, WHY?");
            return;
        }
        CustomForm.Builder form = ((CustomForm.Builder)CustomForm.builder().title(CustomMessages.asString("Forms." + command + "-title"))).input(CustomMessages.asString("Forms." + command + "-description"));
        form.closedOrInvalidResultHandler(() -> CustomMessages.sendMessage((CommandSender)this.getPlayer(), errorMessage, new TagResolver[0]));
        form.validResultHandler(response -> {
            String name = response.asInput();
            this.getPlayer().performCommand("advancedteleport:" + command + " " + name);
        });
        FloodgateApi.getInstance().sendForm(this.floodgateUuid, (FormBuilder)form);
    }

    public void sendDeleteHomeForm() {
        this.sendDropdownForm("delhome", (Collection<String>)this.getHomes().keySet());
    }

    public void sendSetMainHomeForm() {
        this.sendInputForm("setmainhome", "Error.noHomeInput");
    }

    public void sendMoveHomeForm() {
        this.sendDropdownForm("movehome", (Collection<String>)this.getHomes().keySet());
    }

    public void sendWarpForm() {
        this.sendDropdownForm("warp", (Collection<String>)AdvancedTeleportAPI.getWarps().keySet());
    }

    public void sendDeleteWarpForm() {
        this.sendDropdownForm("delwarp", (Collection<String>)AdvancedTeleportAPI.getWarps().keySet());
    }

    public void sendSetWarpForm() {
        this.sendInputForm("setwarp", "Error.noWarpInput");
    }

    public void sendMoveWarpForm() {
        this.sendDropdownForm("movewarp", (Collection<String>)AdvancedTeleportAPI.getWarps().keySet());
    }

    public void sendBlockForm() {
        this.sendDropdownForm("tpblock", this.getVisiblePlayerNames());
    }

    public void sendUnblockForm() {
        this.sendDropdownForm("tpunblock", this.getVisiblePlayerNames());
    }

    public void sendCancelForm(List<String> responders) {
        this.sendDropdownForm("tpcancel", responders);
    }

    public void sendTpoForm() {
        this.sendDropdownForm("tpo", this.getVisiblePlayerNames());
    }

    public void sendTpoHereForm() {
        this.sendDropdownForm("tpohere", this.getVisiblePlayerNames());
    }
}

