/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class UpdateChecker {
    private static final String versionURL = "https://api.spiget.org/v2/resources/64139/versions/latest";
    private static final String descriptionURL = "https://api.spiget.org/v2/resources/64139/updates/latest";

    public static Object[] getUpdate() {
        try {
            JSONObject latestVersionObj = UpdateChecker.getURLResults(versionURL);
            if (latestVersionObj == null) {
                return null;
            }
            String newVersion = (String)latestVersionObj.get((Object)"name");
            if (newVersion.equals(CoreClass.getInstance().getDescription().getVersion())) {
                return null;
            }
            long latestTimestamp = (Long)latestVersionObj.get((Object)"releaseDate") * 1000L;
            if (latestTimestamp <= UpdateChecker.getInternalTimestamp()) {
                return null;
            }
            JSONObject updateDesc = UpdateChecker.getURLResults(descriptionURL);
            String updateName = (String)updateDesc.get((Object)"title");
            return new Object[]{newVersion, updateName};
        }
        catch (java.text.ParseException | ParseException e) {
            CoreClass.getInstance().getLogger().severe("Failed to parse update information.");
            e.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            CoreClass.getInstance().getLogger().severe("Failed to get plugin update information, is Spiget down?");
            return null;
        }
    }

    private static JSONObject getURLResults(String urlStr) throws IOException, ParseException {
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "AdvancedTeleportPA");
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        return (JSONObject)new JSONParser().parse((Reader)reader);
    }

    private static long getInternalTimestamp() throws IOException, java.text.ParseException {
        InputStream updateStream = CoreClass.class.getResourceAsStream("/update.properties");
        Properties updateProperties = new Properties();
        updateProperties.load(updateStream);
        String timestamp = (String)updateProperties.get("update-timestamp");
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(timestamp);
        return date.getTime();
    }
}

