/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport;

import io.github.niestrat99.advancedteleport.UpdateChecker;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.GUIConfig;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.bstats.bukkit.Metrics;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.builder.InjectingApplicationBuilder;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.listeners.MapEventListeners;
import io.github.niestrat99.advancedteleport.listeners.NewListener;
import io.github.niestrat99.advancedteleport.listeners.PlayerListeners;
import io.github.niestrat99.advancedteleport.listeners.WorldLoadListener;
import io.github.niestrat99.advancedteleport.listeners.paper.PaperLegacySignListener;
import io.github.niestrat99.advancedteleport.listeners.paper.PaperSignChangeListener;
import io.github.niestrat99.advancedteleport.listeners.paper.PaperSignOpenListener;
import io.github.niestrat99.advancedteleport.listeners.spigot.SpigotLegacySignListener;
import io.github.niestrat99.advancedteleport.listeners.spigot.SpigotSignChangeListener;
import io.github.niestrat99.advancedteleport.listeners.spigot.SpigotSignOpenListener;
import io.github.niestrat99.advancedteleport.managers.CommandManager;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.managers.MapAssetManager;
import io.github.niestrat99.advancedteleport.managers.MovementManager;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.managers.RTPManager;
import io.github.niestrat99.advancedteleport.managers.SignManager;
import io.github.niestrat99.advancedteleport.managers.TeleportTrackingManager;
import io.github.niestrat99.advancedteleport.sql.BlocklistManager;
import io.github.niestrat99.advancedteleport.sql.DataFailManager;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.PlayerSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import io.github.niestrat99.advancedteleport.utilities.RandomTPAlgorithms;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public final class CoreClass
extends JavaPlugin {
    private static CoreClass instance;
    public static final Executor async;
    public static final Executor sync;
    private static Permission perms;
    private Object[] updateInfo;
    private static final Pattern OLD_VERSION_PATTERN;
    private static final Pattern NEW_VERSION_PATTERN;

    public static CoreClass getInstance() {
        return instance;
    }

    public void onLoad() {
        try {
            this.loadLibraries();
        }
        catch (Exception err) {
            this.getLogger().severe("Failed to load libraries!");
            this.getLogger().throwing(CoreClass.class.getName(), "onLoad", err);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        DataFailManager.get().onDisable();
        try {
            this.hackTheMainFrame();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.getLogger().warning("Failed to shut down async tasks.");
            this.getLogger().throwing(CoreClass.class.getName(), "onDisable", e);
        }
        try {
            RTPManager.saveLocations();
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to save RTP locations: " + e.getMessage());
        }
    }

    public void onEnable() {
        instance = this;
        this.checkVersion();
        this.getLogger().info("Advanced Teleport is now enabling...");
        CoreClass.setupPermissions();
        for (Class config : Arrays.asList(MainConfig.class, CustomMessages.class, GUIConfig.class)) {
            try {
                CoreClass.debug("Loading " + config.getSimpleName() + ".");
                config.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                CoreClass.debug("Finished loading " + config.getSimpleName() + ".");
            }
            catch (NoSuchMethodException ex) {
                this.getLogger().severe(config.getSimpleName() + " is not properly formed, it shouldn't take any constructor arguments. Please inform the developer.");
            }
            catch (InstantiationException | InvocationTargetException e) {
                this.getLogger().severe("Failed to load " + config.getSimpleName() + ": " + e.getCause().getMessage());
            }
            catch (IllegalAccessException e) {
                this.getLogger().severe("Failed to load " + config.getSimpleName() + ", why is the constructor not accessible? Please inform the developer.");
            }
        }
        new NamedLocationManager();
        new SignManager();
        new BlocklistManager();
        new HomeSQLManager();
        new PlayerSQLManager();
        new WarpSQLManager();
        new DataFailManager();
        new MetadataSQLManager();
        new SpawnSQLManager();
        new PluginHookManager();
        MapAssetManager.init();
        CommandManager.registerCommands();
        this.registerEvents();
        CooldownManager.init();
        RandomTPAlgorithms.init();
        new Metrics((JavaPlugin)this, 5146);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            RTPManager.init();
            if (MainConfig.get().CHECK_FOR_UPDATES.get().booleanValue()) {
                this.updateInfo = UpdateChecker.getUpdate();
                if (this.updateInfo != null) {
                    this.getLogger().info("A new version is available!");
                    this.getLogger().info("Current version you're using: " + this.getDescription().getVersion());
                    this.getLogger().info("Latest version available: " + String.valueOf(this.updateInfo[0]));
                    this.getLogger().info("Download link: https://www.spigotmc.org/resources/advancedteleport.64139/");
                } else {
                    this.getLogger().info("Plugin is up to date!");
                }
            }
        });
    }

    private void checkVersion() {
        CoreClass.debug("Performing server version check.");
        Matcher oldVersion = OLD_VERSION_PATTERN.matcher(Bukkit.getBukkitVersion());
        Matcher newVersion = NEW_VERSION_PATTERN.matcher(Bukkit.getBukkitVersion());
        if (oldVersion.find()) {
            String bukkitVersion = oldVersion.group(1);
            int number = Integer.parseInt(bukkitVersion);
            if (number < 17) {
                this.getLogger().severe("!!! YOU ARE USING ADVANCEDTELEPORT ON AN UNSUPPORTED VERSION. !!!");
                this.getLogger().severe("The plugin only receives mainstream support for 1.17.1 to 1.19.x");
                this.getLogger().severe("If you experience an issue with the plugin, please confirm whether it occurs on newer versions as well.");
                this.getLogger().severe("If you experience issues that only occur on your version, then we are not responsible for addressing it.");
                this.getLogger().severe("You have been warned.");
            }
            CoreClass.debug("Detected major version: " + number);
        } else if (!newVersion.find()) {
            this.getLogger().severe("Failed to parse version " + Bukkit.getBukkitVersion() + "!");
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportTrackingManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MovementManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldLoadListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MapEventListeners(), (Plugin)this);
        if (PaperLib.isPaper()) {
            this.registerOrElse(new PaperSignOpenListener(), new PaperLegacySignListener());
            this.getServer().getPluginManager().registerEvents((Listener)new PaperSignChangeListener(), (Plugin)this);
        } else {
            this.registerOrElse(new SpigotSignOpenListener(), new SpigotLegacySignListener());
            this.getServer().getPluginManager().registerEvents((Listener)new SpigotSignChangeListener(), (Plugin)this);
        }
    }

    private void registerOrElse(@NotNull NewListener listener1, @NotNull Listener listener2) {
        if (listener1.canRegister()) {
            this.getServer().getPluginManager().registerEvents((Listener)listener1, (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents(listener2, (Plugin)this);
        }
    }

    private void registerSensitiveEvents(@NotNull NewListener listener) {
        if (!listener.canRegister()) {
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
    }

    private void hackTheMainFrame() throws NoSuchFieldException, IllegalAccessException {
        if (!PaperLib.isPaper()) {
            return;
        }
        BukkitScheduler scheduler = Bukkit.getScheduler();
        Field asyncField = scheduler.getClass().getDeclaredField("asyncScheduler");
        asyncField.setAccessible(true);
        BukkitScheduler asyncScheduler = (BukkitScheduler)asyncField.get(scheduler);
        Field runnersField = scheduler.getClass().getDeclaredField("runners");
        runnersField.setAccessible(true);
        ConcurrentHashMap runners = (ConcurrentHashMap)runnersField.get(asyncScheduler);
        runners.keySet().stream().map(runners::get).filter(runner -> runner.getOwner() == this).forEach(runner -> {
            runner.cancel();
            runners.remove(runner.getTaskId());
        });
        runnersField.set(scheduler, runners);
    }

    private static void setupPermissions() {
        CoreClass.debug("Setting up permissions integration with Vault.");
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            CoreClass.debug("Vault is not on the server, skipping.");
            return;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            CoreClass.debug("Vault is not enabled, skipping.");
            return;
        }
        Optional.ofNullable(Bukkit.getServicesManager().getRegistration(Permission.class)).map(RegisteredServiceProvider::getProvider).ifPresent(permission -> {
            perms = permission;
        });
        CoreClass.debug((String)(perms == null ? "No permissions hook for Vault found." : perms.getName() + " hooked into successfully."));
    }

    public static void playSound(String type, String subType, Player target) {
        String sound = null;
        block5 : switch (type) {
            case "tpa": {
                switch (subType) {
                    case "sent": {
                        sound = MainConfig.get().TPA_REQUEST_SENT.get();
                        break;
                    }
                    case "received": {
                        sound = MainConfig.get().TPA_REQUEST_RECEIVED.get();
                    }
                }
                break;
            }
            case "tpahere": {
                switch (subType) {
                    case "sent": {
                        String string = MainConfig.get().TPAHERE_REQUEST_SENT.get();
                        break block5;
                    }
                    case "received": {
                        String string = MainConfig.get().TPAHERE_REQUEST_RECEIVED.get();
                        break block5;
                    }
                    default: {
                        String string = sound = null;
                    }
                }
            }
        }
        if (sound == null) {
            return;
        }
        if (sound.equalsIgnoreCase("none")) {
            return;
        }
        try {
            target.playSound(target.getLocation(), Sound.valueOf((String)sound), 10.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            CoreClass.getInstance().getLogger().warning(sound + " is an invalid sound name");
        }
    }

    public static Permission getPerms() {
        return perms;
    }

    public static void debug(String message) {
        if (MainConfig.get() == null || MainConfig.get().DEBUG.get().booleanValue()) {
            CoreClass.getInstance().getLogger().info(message);
        }
    }

    public static String getShortLocation(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ() + ", " + String.valueOf(location.getWorld());
    }

    private void loadLibraries() throws ReflectiveOperationException, IOException, URISyntaxException, NoSuchAlgorithmException, InterruptedException {
        InjectingApplicationBuilder.createAppending("AT", this.getClassLoader()).downloadDirectoryPath(this.getDataFolder().toPath().resolve(".libs")).logger(new ProcessLogger(){

            @Override
            public void log(String s, Object ... objects) {
                CoreClass.this.getLogger().info(String.format(s, objects));
            }

            @Override
            public void debug(String message, Object ... args) {
            }
        }).build();
    }

    public Object[] getUpdateInfo() {
        return this.updateInfo;
    }

    static {
        async = task -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), task);
        sync = task -> Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), task);
        OLD_VERSION_PATTERN = Pattern.compile("\\d\\.(\\d+)(?:\\.\\d+)?");
        NEW_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.\\d+|-(?:snapshot|rc|pre)-\\d+)?");
    }
}

