/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils.integrations;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardAdapter {
    private StateFlag honeypotFlag;

    public WorldGuardAdapter() {
        block2: {
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            try {
                StateFlag flag = new StateFlag("allow-honeypots", true);
                registry.register((Flag)flag);
                this.honeypotFlag = flag;
            }
            catch (FlagConflictException e) {
                Flag existing = registry.get("allow-honeypots");
                if (!(existing instanceof StateFlag)) break block2;
                this.honeypotFlag = (StateFlag)existing;
            }
        }
    }

    public StateFlag getWorldGuardFlag() {
        return this.honeypotFlag;
    }

    public boolean isAllowed(Player player, Location location) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
        return set.testState((RegionAssociable)localPlayer, new StateFlag[]{this.honeypotFlag});
    }
}

