/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils.integrations;

import com.google.inject.Inject;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.storagemanager.HoneypotPlayerManager;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    private final Honeypot plugin;
    private final HoneypotPlayerManager playerManager;
    private final HoneypotConfigManager configManager;
    private final HoneypotLogger logger;

    @Inject
    public PlaceholderAPIExpansion(Honeypot plugin, HoneypotLogger logger, HoneypotPlayerManager playerManager, HoneypotConfigManager configManager) {
        this.plugin = plugin;
        this.logger = logger;
        this.playerManager = playerManager;
        this.configManager = configManager;
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getIdentifier() {
        return "honeypot";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        this.logger.debug((Component)Component.text((String)("Param received was: " + params)));
        if (params.equalsIgnoreCase("current_count_broken")) {
            if (player == null) {
                return null;
            }
            int count = this.playerManager.getCount(player);
            return count < 0 ? "0" : String.valueOf(count);
        }
        if (params.startsWith("current_count_broken_")) {
            String playerName = params.split("current_count_broken_")[1];
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
            int count = this.playerManager.getCount(p);
            return count < 0 ? "0" : String.valueOf(count);
        }
        if (params.equalsIgnoreCase("breaks_before_action")) {
            return String.valueOf(this.configManager.getPluginConfig().getInt("blocks-broken-before-action-taken"));
        }
        return null;
    }
}

