/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils.integrations;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.integrations.GriefPreventionAdapter;
import org.reprogle.honeypot.common.utils.integrations.LandsAdapter;
import org.reprogle.honeypot.common.utils.integrations.PermissionAdapter;
import org.reprogle.honeypot.common.utils.integrations.PlaceholderAPIExpansion;
import org.reprogle.honeypot.common.utils.integrations.WorldGuardAdapter;

@Singleton
public class AdapterManager {
    private final Honeypot plugin;
    private final HoneypotConfigManager configManager;
    private final CommandFeedback commandFeedback;
    private WorldGuardAdapter wga = null;
    private GriefPreventionAdapter gpa = null;
    private LandsAdapter la = null;
    private PermissionAdapter pa = null;

    @Inject
    public AdapterManager(Honeypot plugin, HoneypotConfigManager configManager, CommandFeedback commandFeedback) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.commandFeedback = commandFeedback;
    }

    public void onLoadAdapters(Server server) {
        if (server.getPluginManager().getPlugin("WorldGuard") != null) {
            this.wga = new WorldGuardAdapter();
        }
    }

    public void onEnableAdapters(Server server) {
        if (server.getPluginManager().getPlugin("GriefPrevention") != null) {
            this.gpa = new GriefPreventionAdapter(this.configManager);
        }
        if (server.getPluginManager().getPlugin("Lands") != null) {
            this.la = new LandsAdapter(this.plugin);
        }
        if (server.getPluginManager().getPlugin("Vault") != null) {
            this.pa = new PermissionAdapter(this.plugin);
        } else {
            this.plugin.getHoneypotLogger().info(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)"Vault is not installed, some features won't work. Please download Vault here: https://www.spigotmc.org/resources/vault.34315/", (TextColor)NamedTextColor.RED)));
        }
        if (server.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.plugin.getHoneypotLogger().debug((Component)Component.text((String)"PlaceholderAPI is installed on this server, hooking into it"));
            ((PlaceholderAPIExpansion)((Object)this.plugin.getInjector().getInstance(PlaceholderAPIExpansion.class))).register();
        }
    }

    public WorldGuardAdapter getWorldGuardAdapter() {
        return this.wga;
    }

    public GriefPreventionAdapter getGriefPreventionAdapter() {
        return this.gpa;
    }

    public LandsAdapter getLandsAdapter() {
        return this.la;
    }

    public PermissionAdapter getPermissions() {
        return this.pa;
    }

    public boolean checkAllAdapters(Player player, Location location) {
        return !(this.la != null && !this.la.isAllowed(location) || this.gpa != null && !this.gpa.isAllowed(player, location) || this.wga != null && !this.wga.isAllowed(player, location));
    }
}

