/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils.discord;

import java.io.IOException;
import net.kyori.adventure.text.Component;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.discord.WebhookActionType;

public class DiscordWebhookNotifier {
    private final WebhookActionType webhookType;
    private final String webhookUrl;
    private final Block block;
    private final Player player;
    private final HoneypotLogger logger;

    public DiscordWebhookNotifier(WebhookActionType webhookType, String webhookUrl, Block block, Player player, HoneypotLogger logger) {
        this.webhookType = webhookType;
        this.webhookUrl = webhookUrl;
        this.block = block;
        this.player = player;
        this.logger = logger;
    }

    public void send() {
        String finalBody = this.getBodyString();
        new Thread(() -> {
            RequestBody body = RequestBody.create((String)finalBody, (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.webhookUrl).post(body).build();
            new OkHttpClient().newCall(request).enqueue(new Callback(){

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    DiscordWebhookNotifier.this.logger.severe((Component)Component.text((String)("Failed to send webhook: " + e.getMessage())));
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    response.close();
                }
            });
        }).start();
    }

    @NotNull
    private String getBodyString() {
        String jsonTemplate = "{\n  \"content\": \"\",\n  \"tts\": false,\n  \"embeds\": [\n    {\n      \"id\": 595876530,\n      \"description\": \"The honeypot located at %coordinates% in world %world% was triggered by %player%!\",\n      \"fields\": [],\n      \"title\": \"Honeypot Discord Alert - %webhookType%\",\n      \"timestamp\": \"2024-06-24T00:32:00.000Z\",\n      \"color\": 11636736,\n      \"thumbnail\": {\n        \"url\": \"https://mc-heads.net/avatar/%UUID%\"\n      }\n    }\n  ],\n  \"components\": [],\n  \"actions\": {},\n  \"username\": \"Honeypot\"\n}\n";
        String tempBody = switch (this.webhookType) {
            default -> throw new MatchException(null, null);
            case WebhookActionType.ACTION -> jsonTemplate.replace("%webhookType%", "Action Taken");
            case WebhookActionType.BREAK -> jsonTemplate.replace("%webhookType%", "Block Broken");
        };
        return tempBody.replace("%coordinates%", this.block.getX() + ", " + this.block.getY() + ", " + this.block.getZ()).replace("%world%", "\\\"" + this.block.getWorld().getName() + "\\\"").replace("%player%", this.player.getName()).replace("%UUID%", this.player.getUniqueId().toString());
    }
}

