/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public record HoneypotUpdateChecker(Plugin plugin, String link) {
    public void getVersion(Consumer<String> consumer, HoneypotLogger logger) {
        Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> {
            logger.info((Component)Component.text((String)"Checking for updates"));
            try (InputStream inputStream = new URI(this.link).toURL().openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
            }
            catch (IOException | URISyntaxException exception) {
                logger.info((Component)Component.text((String)("Unable to check for updates" + exception.getMessage())));
            }
        });
    }
}

