/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.common.utils.HoneypotLogger;
import org.reprogle.honeypot.common.utils.VersionStatus;

public record HoneypotSupportedVersions(Plugin plugin, String version) {
    public void getSupportedVersions(Consumer<VersionStatus> consumer, HoneypotLogger logger) {
        Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> {
            logger.info((Component)Component.text((String)"Checking if this server version is supported"));
            try (InputStream inputStream = new URI("https://raw.githubusercontent.com/TerrorByteTW/Honeypot/master/supported-versions/" + this.version).toURL().openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (!scanner.hasNextLine()) {
                    return;
                }
                String firstLine = scanner.nextLine().trim();
                if (firstLine.equalsIgnoreCase("pulled")) {
                    String reason = scanner.hasNextLine() ? scanner.nextLine() : "This version of Honeypot has been pulled, it's recommended you update to the next available version immediately!";
                    consumer.accept(new VersionStatus(true, reason));
                } else {
                    consumer.accept(new VersionStatus(false, firstLine));
                }
            }
            catch (IOException | URISyntaxException exception) {
                logger.warning((Component)Component.text((String)("Unable to check supported versions: " + exception.getMessage())));
            }
        });
    }
}

