/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;

public class HoneypotLogger {
    private final HoneypotConfigManager configManager;
    private final File logFile;
    private final Honeypot plugin;

    @Inject
    public HoneypotLogger(@Named(value="HoneypotLogFile") File logFile, Honeypot plugin, HoneypotConfigManager configManager) {
        this.logFile = logFile;
        this.plugin = plugin;
        this.configManager = configManager;
        try {
            if (logFile.createNewFile()) {
                plugin.getLogger().info("Logs file created: " + logFile.getName());
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not create the honeypot.log file for logging!");
        }
    }

    public void debug(Component message) {
        if (!this.configManager.getPluginConfig().getBoolean("enable-logging").booleanValue()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.logFile, true));){
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            bw.append("[").append(dtf.format(now)).append("] DEBUG: ").append(PlainTextComponentSerializer.plainText().serialize(message)).append("\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("An error occured while attempting to log to the honeypot.log file! " + String.valueOf(e));
        }
    }

    public void info(Component message) {
        this.plugin.getLogger().info(PlainTextComponentSerializer.plainText().serialize(message));
        if (!this.configManager.getPluginConfig().getBoolean("enable-logging").booleanValue()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.logFile, true));){
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            bw.append("[").append(dtf.format(now)).append("] INFO: ").append(PlainTextComponentSerializer.plainText().serialize(message)).append("\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("An error occured while attempting to log to the honeypot.log file! " + String.valueOf(e));
        }
    }

    public void warning(Component message) {
        this.plugin.getLogger().warning(PlainTextComponentSerializer.plainText().serialize(message));
        if (!this.configManager.getPluginConfig().getBoolean("enable-logging").booleanValue()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.logFile, true));){
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            bw.append("[").append(dtf.format(now)).append("] WARNING: ").append(PlainTextComponentSerializer.plainText().serialize(message)).append("\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("An error occured while attempting to log to the honeypot.log file! " + String.valueOf(e));
        }
    }

    public void severe(Component message) {
        this.plugin.getLogger().severe(PlainTextComponentSerializer.plainText().serialize(message));
        if (!this.configManager.getPluginConfig().getBoolean("enable-logging").booleanValue()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.logFile, true));){
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            bw.append("[").append(dtf.format(now)).append("] SEVERE: ").append(PlainTextComponentSerializer.plainText().serialize(message)).append("\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("An error occured while attempting to log to the honeypot.log file! " + String.valueOf(e));
        }
    }
}

