/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import com.google.inject.Singleton;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.bukkit.plugin.Plugin;

@Singleton
public class HoneypotConfigManager {
    private static YamlDocument config;
    private static YamlDocument guiConfig;
    private static YamlDocument honeypotsConfig;
    private static YamlDocument languageFile;
    private final List<String> languages = Arrays.asList("en_US", "es_MX", "fr_FR", "ja_JP", "zh_CN");

    public void setupConfig(Plugin plugin) {
        plugin.getLogger().info("Attempting to load all plugin config files...");
        try {
            config = YamlDocument.create((File)new File(plugin.getDataFolder(), "config.yml"), (InputStream)plugin.getResource("config.yml"), (Settings[])new Settings[]{GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build()});
            config.update();
            config.save();
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not create/load plugin config, disabling! Please alert the plugin author with the following info: " + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        try {
            guiConfig = YamlDocument.create((File)new File(plugin.getDataFolder(), "gui.yml"), (InputStream)plugin.getResource("gui.yml"), (Settings[])new Settings[]{GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build()});
            guiConfig.update();
            guiConfig.save();
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not create/load GUI config, disabling! Please alert the plugin author with following info: " + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        try {
            honeypotsConfig = YamlDocument.create((File)new File(plugin.getDataFolder(), "honeypots.yml"), (InputStream)plugin.getResource("honeypots.yml"), (Settings[])new Settings[]{GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.DEFAULT});
            guiConfig.update();
            guiConfig.save();
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not create/load Honeypot config, disabling! Please alert the plugin author with following info: " + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        String language = config.getString("language");
        if (!this.languages.contains(language) && !config.getBoolean("bypass-language-check").booleanValue()) {
            plugin.getLogger().warning("Language is currently set to " + language + ". This language is currently not supported, defaulting to en_US.");
            language = "en_US";
        }
        try {
            languageFile = YamlDocument.create((File)new File(new File(plugin.getDataFolder(), "lang"), language + ".yml"), (InputStream)plugin.getResource("lang/" + language + ".yml"), (Settings[])new Settings[]{GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("language-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build()});
            languageFile.update();
            languageFile.save();
            plugin.getLogger().info("Language set to: " + language);
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not load language file, disabling! Please alert the plugin author with the following info:" + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        plugin.getLogger().info("All plugin config files successfully loaded");
    }

    public YamlDocument getPluginConfig() {
        return config;
    }

    public YamlDocument getGuiConfig() {
        return guiConfig;
    }

    public YamlDocument getHoneypotsConfig() {
        return honeypotsConfig;
    }

    public YamlDocument getLanguageFile() {
        return languageFile;
    }
}

