/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.storagemanager.HoneypotBlockManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

@Singleton
public class GhostHoneypotFixer {
    private final HoneypotConfigManager configManager;
    private final HoneypotLogger logger;
    private final HoneypotBlockManager blockManager;
    private final Honeypot plugin;
    private ScheduledTask task;

    @Inject
    public GhostHoneypotFixer(Honeypot plugin, HoneypotLogger logger, HoneypotBlockManager blockManager, HoneypotConfigManager configManager) {
        this.plugin = plugin;
        this.logger = logger;
        this.blockManager = blockManager;
        this.configManager = configManager;
        if (configManager.getPluginConfig().getBoolean("ghost-honeypot-checker.enable").booleanValue()) {
            logger.info((Component)Component.text((String)"Starting the ghost checker task! If you need to change the settings for this function, edit the config then do /honeypot reload"));
        }
    }

    public void startTask() {
        this.task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> {
            this.logger.info((Component)Component.text((String)"Running ghost Honeypot checks..."));
            int removedPots = 0;
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                List<HoneypotBlockObject> pots = this.blockManager.getAllHoneypots(world);
                for (HoneypotBlockObject pot : pots) {
                    Material block;
                    try {
                        block = pot.getBlock().getType();
                    }
                    catch (NullPointerException e) {
                        this.logger.warning((Component)Component.text((String)("Could not get the material for Honeypot at " + pot.getCoordinates() + " because the world isn't loaded yet (Maybe running Folia?)")));
                        continue;
                    }
                    if (!block.equals((Object)Material.AIR) && !block.equals((Object)Material.WATER) && !block.equals((Object)Material.LAVA)) continue;
                    this.logger.debug((Component)Component.text((String)("Found ghost Honeypot at " + pot.getCoordinates() + " in world " + pot.getWorld() + ". Removing")));
                    this.blockManager.deleteBlock(pot.getBlock());
                    ++removedPots;
                }
            }
            this.logger.info((Component)Component.text((String)("Finished ghost Honeypot checks! Removed " + removedPots + " ghost Honeypots.")));
        }, 10L, 1200L * (long)this.configManager.getPluginConfig().getInt("ghost-honeypot-checker.check-interval").intValue());
    }

    public void cancelTask() {
        this.task.cancel();
    }
}

