/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.utils;

import com.google.inject.Inject;
import dev.dejvokep.boostedyaml.YamlDocument;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.BehaviorProcessor;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.Registry;
import org.reprogle.honeypot.common.commands.CommandFeedback;
import org.reprogle.honeypot.common.utils.HoneypotConfigManager;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public class ActionHandler {
    private final Honeypot plugin;
    private final HoneypotLogger logger;
    private final HoneypotConfigManager configManager;
    private final CommandFeedback commandFeedback;
    private final MiniMessage mm = MiniMessage.miniMessage();

    @Inject
    public ActionHandler(Honeypot plugin, HoneypotLogger logger, HoneypotConfigManager configManager, CommandFeedback commandFeedback) {
        this.plugin = plugin;
        this.logger = logger;
        this.configManager = configManager;
        this.commandFeedback = commandFeedback;
    }

    public void handleCustomAction(String action, Block block, Player player) {
        this.plugin.getHoneypotLogger().debug((Component)Component.text((String)("Handling action " + action + " for player " + player.getName() + " at location " + String.valueOf(block.getLocation()))));
        if (Registry.getBehaviorRegistry().getBehaviorProvider(action) != null) {
            BehaviorProcessor.process(Registry.getBehaviorRegistry().getBehaviorProvider(action), player, block);
            return;
        }
        YamlDocument config = this.configManager.getHoneypotsConfig();
        if (config.contains(action)) {
            List commands = config.getStringList(action + ".commands");
            List permissionsAdd = config.getStringList(action + ".permissions-add");
            List permissionsRemove = config.getStringList(action + ".permissions-remove");
            List broadcasts = config.getStringList(action + ".broadcasts");
            List messages = config.getStringList(action + ".messages");
            if (!commands.isEmpty()) {
                for (String command : commands) {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), PlainTextComponentSerializer.plainText().serialize(this.formatMessage(command, block, player, true)));
                }
            }
            if (!messages.isEmpty()) {
                for (String message : messages) {
                    player.sendMessage(this.formatMessage(message, block, player, false));
                }
            }
            if (!broadcasts.isEmpty()) {
                for (String broadcast : broadcasts) {
                    this.plugin.getServer().broadcast(this.formatMessage(broadcast, block, player, false));
                }
            }
            if (this.plugin.getAdapterManager().getPermissions() != null) {
                if (!permissionsAdd.isEmpty()) {
                    for (String permission : permissionsAdd) {
                        this.plugin.getAdapterManager().getPermissions().getPermissionProvider().playerAdd(null, (OfflinePlayer)player, permission);
                    }
                }
                if (!permissionsRemove.isEmpty()) {
                    for (String permission : permissionsRemove) {
                        this.plugin.getAdapterManager().getPermissions().getPermissionProvider().playerRemove(null, (OfflinePlayer)player, permission);
                    }
                }
            } else if (!permissionsAdd.isEmpty() || !permissionsRemove.isEmpty()) {
                this.logger.warning(this.commandFeedback.getChatPrefix().append((Component)Component.text((String)"Vault is not installed, Honeypots that modify permissions won't work. Please download here: https://www.spigotmc.org/resources/vault.34315/", (TextColor)NamedTextColor.RED)));
            }
        } else {
            this.logger.warning((Component)Component.text((String)("A Honeypot tried to run using action: " + action + ", but that action doesn't exist! Please verify your honeypots.yml config")));
        }
    }

    private Component formatMessage(String message, Block block, Player player, boolean command) {
        String formattedString = message.replace("%player%", player.getName()).replace("%pLocation%", player.getLocation().getX() + " " + player.getLocation().getY() + " " + player.getLocation().getZ()).replace("%bLocation%", block.getLocation().getX() + " " + block.getLocation().getY() + " " + block.getLocation().getZ()).replace("%world%", block.getLocation().getWorld().getName());
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            formattedString = PlaceholderAPI.setPlaceholders((Player)player, (String)formattedString);
        }
        return command ? Component.text((String)formattedString) : ((TextComponent.Builder)Component.text().append(this.mm.deserialize((Object)formattedString))).build();
    }
}

