/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storageproviders;

import com.google.common.base.Objects;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.storageproviders.HoneypotStore;

public abstract class StorageProvider {
    private final String providerName = this.getClass().getAnnotation(HoneypotStore.class).name();

    protected StorageProvider() {
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StorageProvider)) {
            return false;
        }
        StorageProvider provider = (StorageProvider)o;
        if (o == this) {
            return true;
        }
        return provider.getProviderName().equals(this.providerName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.providerName});
    }

    public abstract void createHoneypotBlock(Block var1, String var2);

    public abstract void removeHoneypotBlock(Block var1);

    public abstract boolean isHoneypotBlock(Block var1);

    public abstract HoneypotBlockObject getHoneypotBlock(Block var1);

    public abstract String getAction(Block var1);

    public abstract void deleteAllHoneypotBlocks(@Nullable World var1);

    public abstract List<HoneypotBlockObject> getAllHoneypots(@Nullable World var1);

    public abstract List<HoneypotBlockObject> getNearbyHoneypots(Location var1, int var2);
}

