/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storageproviders;

import com.google.common.base.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class HoneypotBlockObject
implements PersistentDataType<String, HoneypotBlockObject> {
    private final String coordinates;
    private final String world;
    private final String action;

    public HoneypotBlockObject(Block block, String action) {
        this.coordinates = block.getX() + ", " + block.getY() + ", " + block.getZ();
        this.world = block.getWorld().getName();
        this.action = action;
    }

    public HoneypotBlockObject(String worldName, String coordinates, String action) {
        this.coordinates = coordinates;
        this.world = worldName;
        this.action = action;
    }

    public HoneypotBlockObject(String worldName, int x, int y, int z, String action) {
        this.coordinates = String.join((CharSequence)", ", Integer.toString(x), Integer.toString(y), Integer.toString(z));
        this.world = worldName;
        this.action = action;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public Location getLocation() {
        String[] coords = this.coordinates.split(", ");
        return new Location(Bukkit.getWorld((String)this.world), (double)Integer.parseInt(coords[0]), (double)Integer.parseInt(coords[1]), (double)Integer.parseInt(coords[2]));
    }

    public String getAction() {
        return this.action;
    }

    public String getWorld() {
        return this.world;
    }

    public Block getBlock() {
        String[] coords = this.coordinates.split(", ");
        return Bukkit.getWorld((String)this.world).getBlockAt(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
    }

    public boolean equals(Object o) {
        if (!(o instanceof HoneypotBlockObject)) {
            return false;
        }
        HoneypotBlockObject honeypot = (HoneypotBlockObject)o;
        if (o == this) {
            return true;
        }
        return honeypot.coordinates.equalsIgnoreCase(this.coordinates) && honeypot.world.equals(this.world);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.coordinates, this.world, this.action});
    }

    @NotNull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @NotNull
    public Class<HoneypotBlockObject> getComplexType() {
        return HoneypotBlockObject.class;
    }

    @NotNull
    public String toPrimitive(@NotNull HoneypotBlockObject complex, @NotNull PersistentDataAdapterContext context) {
        return this.world + ";;" + this.coordinates + ";;" + this.action;
    }

    @NotNull
    public HoneypotBlockObject fromPrimitive(String primitive, @NotNull PersistentDataAdapterContext context) {
        String[] strings = primitive.split(";;");
        return new HoneypotBlockObject(strings[0], strings[1], strings[2]);
    }

    public String toString() {
        return this.world + " " + this.coordinates + " " + this.action;
    }
}

