/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager.sqlite;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.plugin.Plugin;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.storagemanager.sqlite.Database;
import org.reprogle.honeypot.common.storagemanager.sqlite.patches.ConvertToSpatialIndexing01;
import org.reprogle.honeypot.common.storagemanager.sqlite.patches.SQLitePatch;
import org.reprogle.honeypot.common.storagemanager.sqlite.patches.UpdateHistoryTable00;
import org.reprogle.honeypot.common.storageproviders.HoneypotStore;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

@HoneypotStore(name="sqlite")
@Singleton
public class SQLite
extends Database {
    private final Honeypot plugin;
    private final HoneypotLogger logger;
    private final List<SQLitePatch> patches = new ArrayList<ConvertToSpatialIndexing01>(List.of(new UpdateHistoryTable00(), new ConvertToSpatialIndexing01()));
    private final int DB_VERSION = 2;
    private final String SQLITE_CREATE_PLAYERS_TABLE = "CREATE TABLE IF NOT EXISTS honeypot_players (`playerName` VARCHAR NOT NULL,`blocksBroken` INT NOT NULL,PRIMARY KEY (`playerName`));";
    private final String SQLITE_CREATE_BLOCKS_TABLE = "CREATE TABLE IF NOT EXISTS honeypot_blocks (id INTEGER PRIMARY KEY,world TEXT NOT NULL,action TEXT NOT NULL,FOREIGN KEY (id) REFERENCES honeypot_index(id) ON DELETE CASCADE);";
    private final String SQLITE_CREATE_HISTORY_TABLE = "CREATE TABLE IF NOT EXISTS honeypot_history (`datetime` VARCHAR NOT NULL,`playerName` varchar NOT NULL,`playerUUID` VARCHAR NOT NULL,`coordinates` VARCHAR NOT NULL,`world` VARCHAR NOT NULL,`type` VARCHAR NOT NULL,`action` VARCHAR NOT NULL);";
    private final String SQLITE_CREATE_INDEX_TABLE = "CREATE VIRTUAL TABLE IF NOT EXISTS honeypot_index USING rtree( id INTEGER PRIMARY KEY, x_min INTEGER, x_max INTEGER, y_min INTEGER, y_max INTEGER, z_min INTEGER, z_max INTEGER);";
    private final String SET_PRAGMA = "PRAGMA user_version = 2;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public SQLite(Honeypot plugin, HoneypotLogger logger) {
        super(plugin, logger);
        Statement s;
        this.logger = logger;
        this.plugin = plugin;
        this.connection = this.getSQLConnection();
        try {
            s = this.connection.createStatement();
            try {
                PreparedStatement ps = this.connection.prepareStatement("PRAGMA user_version;");
                ResultSet rs = ps.executeQuery();
                int userVersion = rs.getInt("user_version");
                logger.debug((Component)Component.text((String)"Checking if DB needs upgrading"));
                boolean upgradeNecessary = this.checkIfUpgradeNecessary(this.connection, userVersion);
                if (!upgradeNecessary) {
                    logger.debug((Component)Component.text((String)"No upgrade necessary, first run or DB schema is up to date. Creating tables if they don't exist, otherwise skipping"));
                    s.executeUpdate("CREATE VIRTUAL TABLE IF NOT EXISTS honeypot_index USING rtree( id INTEGER PRIMARY KEY, x_min INTEGER, x_max INTEGER, y_min INTEGER, y_max INTEGER, z_min INTEGER, z_max INTEGER);");
                    s.executeUpdate("CREATE TABLE IF NOT EXISTS honeypot_players (`playerName` VARCHAR NOT NULL,`blocksBroken` INT NOT NULL,PRIMARY KEY (`playerName`));");
                    s.executeUpdate("CREATE TABLE IF NOT EXISTS honeypot_blocks (id INTEGER PRIMARY KEY,world TEXT NOT NULL,action TEXT NOT NULL,FOREIGN KEY (id) REFERENCES honeypot_index(id) ON DELETE CASCADE);");
                    s.executeUpdate("CREATE TABLE IF NOT EXISTS honeypot_history (`datetime` VARCHAR NOT NULL,`playerName` varchar NOT NULL,`playerUUID` VARCHAR NOT NULL,`coordinates` VARCHAR NOT NULL,`world` VARCHAR NOT NULL,`type` VARCHAR NOT NULL,`action` VARCHAR NOT NULL);");
                } else {
                    logger.debug((Component)Component.text((String)("It appears the plugin DB needs patched, userVersion is " + userVersion + " and the current version is 2. Let's apply patches now")));
                    for (SQLitePatch patch : this.patches) {
                        if (!this.connection.isClosed()) {
                            this.connection.close();
                        }
                        if (userVersion < patch.patchedIn()) {
                            logger.debug((Component)Component.text((String)("Applying patch '" + patch.getClass().getName() + "'")));
                            this.connection = this.getSQLConnection();
                            patch.update(this.connection, logger);
                            continue;
                        }
                        logger.debug((Component)Component.text((String)("Patch '" + patch.getClass().getName() + "' version is " + patch.patchedIn() + " while the DB_VERSION is 2. Skipping since this patch is not needed")));
                    }
                    logger.debug((Component)Component.text((String)"Finished applying patches"));
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException e) {
            logger.severe((Component)Component.text((String)("SQLException occurred while creating SQLite connection: " + e.getMessage())));
            logger.severe((Component)Component.text((String)("Full stack" + Arrays.toString(e.getStackTrace()))));
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.severe((Component)Component.text((String)("Failed to close SQLite Connection: " + String.valueOf(e))));
            }
        }
        this.connection = this.getSQLConnection();
        try {
            s = this.connection.createStatement();
            try {
                s.executeUpdate("PRAGMA user_version = 2;");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException e) {
            logger.severe((Component)Component.text((String)("SQLException occurred while creating SQLite connection: " + e.getMessage())));
            logger.severe((Component)Component.text((String)("Full stack" + Arrays.toString(e.getStackTrace()))));
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.severe((Component)Component.text((String)("Failed to close SQLite Connection: " + String.valueOf(e))));
            }
        }
    }

    @Override
    public Connection getSQLConnection() {
        File dataFolder = new File(this.plugin.getDataFolder(), "honeypot.db");
        if (!dataFolder.exists()) {
            try {
                boolean success = dataFolder.createNewFile();
                if (success) {
                    this.logger.info((Component)Component.text((String)"Created data folder"));
                } else {
                    this.logger.severe((Component)Component.text((String)"Could not create data folder!"));
                }
            }
            catch (IOException e) {
                this.logger.severe((Component)Component.text((String)"Could not create honeypot.db file"));
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dataFolder));
            return this.connection;
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("SQLite exception on initialize: " + String.valueOf(e))));
        }
        catch (ClassNotFoundException e) {
            this.logger.severe((Component)Component.text((String)("SQLite JDBC Library not found. Please install this on your PC to use SQLite: " + String.valueOf(e))));
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        return null;
    }

    public boolean checkIfUpgradeNecessary(Connection connection, int userVersion) {
        boolean tablesExist;
        boolean alreadyInitialized = userVersion >= 2;
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%';");
            ResultSet rs = ps.executeQuery();
            tablesExist = rs.next();
        }
        catch (SQLException e) {
            tablesExist = false;
        }
        return !alreadyInitialized && tablesExist;
    }
}

