/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager.sqlite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.reprogle.honeypot.Honeypot;
import org.reprogle.honeypot.common.storagemanager.queue.QueueManager;
import org.reprogle.honeypot.common.storageproviders.HoneypotBlockObject;
import org.reprogle.honeypot.common.storageproviders.HoneypotPlayerHistoryObject;
import org.reprogle.honeypot.common.storageproviders.StorageProvider;
import org.reprogle.honeypot.common.utils.HoneypotLogger;

public abstract class Database
extends StorageProvider {
    private static final String PLAYER_TABLE = "honeypot_players";
    private static final String BLOCK_TABLE = "honeypot_blocks";
    private static final String HISTORY_TABLE = "honeypot_history";
    private static final String INDEX_TABLE = "honeypot_index";
    private static final String SELECT = "SELECT * FROM ";
    private static final String SELECT_EXISTS = "SELECT EXISTS (";
    private static final String FAIL_TO_CLOSE = "Failed to close SQLite connection: ";
    private static final String DELETE = "DELETE FROM ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String WHERE = " WHERE x_min >= ? AND x_max <= ? AND y_min >= ? AND y_max <= ? AND z_min >= ? AND z_max <= ? AND world = ?";
    final Honeypot plugin;
    final QueueManager qm = QueueManager.getInstance();
    private final HoneypotLogger logger;
    Connection connection;

    protected Database(Honeypot instance, HoneypotLogger logger) {
        this.plugin = instance;
        this.logger = logger;
    }

    public abstract Connection getSQLConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createHoneypotBlock(Block block, String action) {
        String coordinates = block.getX() + ", " + block.getY() + ", " + block.getZ();
        String worldName = block.getWorld().getName();
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("INSERT INTO honeypot_index (x_min, x_max, y_min, y_max, z_min, z_max) VALUES (?, ?, ?, ?, ?, ?);");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            this.qm.addToQueue(ps);
            ps = c.prepareStatement("INSERT INTO honeypot_blocks (id, world, action) VALUES (last_insert_rowid(), ?, ?);");
            ps.setString(1, block.getWorld().getName());
            ps.setString(2, action);
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHoneypotBlock(Block block) {
        String coordinates = block.getX() + ", " + block.getY() + ", " + block.getZ();
        String worldName = block.getWorld().getName();
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("DELETE FROM honeypot_blocks WHERE id in (SELECT id FROM honeypot_index WHERE x_min <= ? AND x_max >= ?AND y_min <= ? AND y_max >= ?AND z_min <= ? AND z_max >= ?);");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            this.qm.addToQueue(ps);
            ps = c.prepareStatement("DELETE FROM honeypot_index WHERE x_min <= ? AND x_max >= ? AND y_min <= ? AND y_max >= ? AND z_min <= ? AND z_max >= ?;");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while remove executing SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHoneypotBlock(Block block) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT EXISTS (SELECT 1 FROM honeypot_index JOIN honeypot_blocks ON honeypot_index.id = honeypot_blocks.id WHERE x_min >= ? AND x_max <= ? AND y_min >= ? AND y_max <= ? AND z_min >= ? AND z_max <= ? AND world = ?);");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            ps.setString(7, block.getWorld().getName());
            rs = ps.executeQuery();
            boolean bl = rs.next() && rs.getInt(1) == 1;
            return bl;
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing check SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAction(Block block) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT honeypot_blocks.action FROM honeypot_index JOIN honeypot_blocks ON honeypot_index.id = honeypot_blocks.id  WHERE x_min >= ? AND x_max <= ? AND y_min >= ? AND y_max <= ? AND z_min >= ? AND z_max <= ? AND world = ?;");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            ps.setString(7, block.getWorld().getName());
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("action");
                return string;
            }
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing action SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HoneypotBlockObject getHoneypotBlock(Block block) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT honeypot_index.x_min, honeypot_index.y_min, honeypot_index.z_min, honeypot_blocks.world, honeypot_blocks.action FROM honeypot_index JOIN honeypot_blocks ON honeypot_index.id = honeypot_blocks.id  WHERE x_min >= ? AND x_max <= ? AND y_min >= ? AND y_max <= ? AND z_min >= ? AND z_max <= ? AND world = ?;");
            ps.setString(1, Integer.toString(block.getX()));
            ps.setString(2, Integer.toString(block.getX()));
            ps.setString(3, Integer.toString(block.getY()));
            ps.setString(4, Integer.toString(block.getY()));
            ps.setString(5, Integer.toString(block.getZ()));
            ps.setString(6, Integer.toString(block.getZ()));
            ps.setString(7, block.getWorld().getName());
            rs = ps.executeQuery();
            if (rs.next()) {
                HoneypotBlockObject honeypotBlockObject = new HoneypotBlockObject(rs.getString("world"), rs.getInt("x_min"), rs.getInt("y_min"), rs.getInt("z_min"), rs.getString("action"));
                return honeypotBlockObject;
            }
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing action SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HoneypotBlockObject> getNearbyHoneypots(Location location, int radius) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<HoneypotBlockObject> blocks = new ArrayList<HoneypotBlockObject>();
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT honeypot_index.x_min, honeypot_index.y_min, honeypot_index.z_min, honeypot_blocks.world, honeypot_blocks.action FROM honeypot_index JOIN honeypot_blocks ON honeypot_index.id = honeypot_blocks.id  WHERE x_min >= ? AND x_max <= ? AND y_min >= ? AND y_max <= ? AND z_min >= ? AND z_max <= ? AND world = ?;");
            int xMin = Math.min(location.getBlockX() - radius, location.getBlockX() + radius);
            int xMax = Math.max(location.getBlockX() - radius, location.getBlockX() + radius);
            int yMin = Math.min(location.getBlockY() - radius, location.getBlockY() + radius);
            int yMax = Math.max(location.getBlockY() - radius, location.getBlockY() + radius);
            int zMin = Math.min(location.getBlockZ() - radius, location.getBlockZ() + radius);
            int zMax = Math.max(location.getBlockZ() - radius, location.getBlockZ() + radius);
            ps.setString(1, Integer.toString(xMin));
            ps.setString(2, Integer.toString(xMax));
            ps.setString(3, Integer.toString(yMin));
            ps.setString(4, Integer.toString(yMax));
            ps.setString(5, Integer.toString(zMin));
            ps.setString(6, Integer.toString(zMax));
            ps.setString(7, location.getWorld().getName());
            rs = ps.executeQuery();
            while (rs.next()) {
                blocks.add(new HoneypotBlockObject(rs.getString("world"), rs.getInt("x_min"), rs.getInt("y_min"), rs.getInt("z_min"), rs.getString("action")));
            }
            ArrayList<HoneypotBlockObject> arrayList = blocks;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing action SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HoneypotBlockObject> getAllHoneypots(@Nullable World world) {
        ArrayList<HoneypotBlockObject> blocks = new ArrayList<HoneypotBlockObject>();
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT honeypot_index.x_min, honeypot_index.y_min, honeypot_index.z_min, honeypot_blocks.world, honeypot_blocks.action FROM honeypot_index JOIN honeypot_blocks ON honeypot_index.id = honeypot_blocks.id;");
            rs = ps.executeQuery();
            while (rs.next()) {
                blocks.add(new HoneypotBlockObject(rs.getString("world"), rs.getInt("x_min"), rs.getInt("y_min"), rs.getInt("z_min"), rs.getString("action")));
            }
            ArrayList<HoneypotBlockObject> arrayList = blocks;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing action SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHoneypotPlayer(Player player, int blocksBroken) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("INSERT INTO honeypot_players (playerName, blocksBroken) VALUES (?, ?);");
            ps.setString(1, player.getUniqueId().toString());
            ps.setInt(2, blocksBroken);
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerCount(Player playerName, int blocksBroken) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("REPLACE INTO honeypot_players (playerName, blocksBroken) VALUES (?, ?);");
            ps.setString(1, playerName.getUniqueId().toString());
            ps.setInt(2, blocksBroken);
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing count update SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(Player player) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT * FROM honeypot_players WHERE playerName = ?;");
            ps.setString(1, player.getUniqueId().toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("playerName").equalsIgnoreCase(player.getUniqueId().toString())) continue;
                int n = rs.getInt("blocksBroken");
                return n;
            }
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing count retrieval SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(OfflinePlayer player) {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT * FROM honeypot_players WHERE playerName = ?;");
            ps.setString(1, player.getUniqueId().toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("playerName").equalsIgnoreCase(player.getUniqueId().toString())) continue;
                int n = rs.getInt("blocksBroken");
                return n;
            }
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing count retrieval SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllHoneypotBlocks(@Nullable World world) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("DELETE FROM honeypot_blocks;");
            this.qm.addToQueue(ps);
            ps = c.prepareStatement("DELETE FROM honeypot_index;");
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllPlayers() {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("DELETE FROM honeypot_players;");
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllHistory() {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("DELETE FROM honeypot_history;");
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on player table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerHistory(Player p, HoneypotBlockObject block, String type) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("INSERT INTO honeypot_history (datetime, playerName, playerUUID, coordinates, world, type, action) VALUES (DATETIME('now', 'localtime'), ?, ?, ?, ?, ?, ?);");
            ps.setString(1, p.getName());
            ps.setString(2, p.getUniqueId().toString());
            ps.setString(3, block.getCoordinates());
            ps.setString(4, block.getWorld());
            ps.setString(5, type);
            ps.setString(6, block.getAction());
            this.qm.addToQueue(ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on history table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoneypotPlayerHistoryObject> retrieveHistory(Player p) {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getSQLConnection();
            ps = c.prepareStatement("SELECT * FROM honeypot_history WHERE playerUUID = ? ORDER BY datetime DESC;");
            ps.setString(1, p.getUniqueId().toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<HoneypotPlayerHistoryObject> history = new ArrayList<HoneypotPlayerHistoryObject>();
            while (rs.next()) {
                HoneypotBlockObject hbo = new HoneypotBlockObject(rs.getString("world"), rs.getString("coordinates"), rs.getString("action"));
                history.add(new HoneypotPlayerHistoryObject(rs.getString("datetime"), rs.getString("playerName"), rs.getString("playerUUID"), hbo, rs.getString("type")));
            }
            ArrayList<HoneypotPlayerHistoryObject> arrayList = history;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing create SQL statement on history table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlayerHistory(Player p, int ... n) {
        Connection c = null;
        Statement ps = null;
        try {
            c = this.getSQLConnection();
            if (n.length > 0) {
                ps = c.prepareStatement("DELETE FROM honeypot_history WHERE rowid IN (SELECT rowid FROM honeypot_history WHERE playerUUID = ? ORDER BY rowid DESC LIMIT ?);");
                ps.setString(1, p.getUniqueId().toString());
                ps.setInt(2, n[0]);
            } else {
                ps = c.prepareStatement("DELETE FROM honeypot_history WHERE playerUUID = ?;");
                ps.setString(1, p.getUniqueId().toString());
            }
            this.qm.addToQueue((PreparedStatement)ps);
        }
        catch (SQLException e) {
            this.logger.severe((Component)Component.text((String)("Error while executing SQL statement on block table: " + String.valueOf(e))));
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.severe((Component)Component.text((String)(FAIL_TO_CLOSE + String.valueOf(e))));
            }
        }
    }
}

