/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.honeypot.common.storagemanager.queue;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import org.reprogle.honeypot.common.storagemanager.queue.ListenableQueue;

public class QueueManager {
    private static QueueManager instance = null;
    final ListenableQueue<PreparedStatement> queue = new ListenableQueue(new LinkedList());

    private QueueManager() {
        this.queue.registerListener(element -> {
            while (this.queue.peek() != null) {
                try {
                    PreparedStatement ps = this.queue.poll();
                    try {
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static synchronized QueueManager getInstance() {
        if (instance == null) {
            instance = new QueueManager();
        }
        return instance;
    }

    public boolean addToQueue(PreparedStatement ps) {
        return this.queue.offer(ps);
    }
}

